/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.internal.FunctionTrackingCounter;
import io.micrometer.core.instrument.prometheus.PrometheusCounter;
import io.micrometer.core.instrument.prometheus.PrometheusDistributionSummary;
import io.micrometer.core.instrument.prometheus.PrometheusGauge;
import io.micrometer.core.instrument.prometheus.PrometheusLongTaskTimer;
import io.micrometer.core.instrument.prometheus.PrometheusTagFormatter;
import io.micrometer.core.instrument.prometheus.PrometheusTimer;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusCollector;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusLongTaskTimer;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusSummary;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.MapAccess;
import io.micrometer.core.instrument.util.MeterId;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class PrometheusMeterRegistry
extends AbstractMeterRegistry {
    private static final PrometheusTagFormatter tagFormatter = new PrometheusTagFormatter();
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, Collector> collectorMap = new ConcurrentHashMap<String, Collector>();
    private final ConcurrentMap<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();

    public PrometheusMeterRegistry() {
        this(new CollectorRegistry());
    }

    public PrometheusMeterRegistry(CollectorRegistry registry) {
        this(registry, Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    public String scrape() {
        StringWriter writer = new StringWriter();
        try {
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(mClass::isInstance).map(mClass::cast);
    }

    @Override
    public Optional<Meter> findMeter(Meter.Type type, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).filter(m -> m.getType().equals((Object)type));
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        MeterId id = new MeterId(name, this.withCommonTags(tags));
        io.prometheus.client.Counter counter = this.collectorByName(io.prometheus.client.Counter.class, name, n -> (io.prometheus.client.Counter)this.buildCollector(id, (SimpleCollector.Builder)io.prometheus.client.Counter.build()));
        return MapAccess.computeIfAbsent(this.meterMap, id, c -> new PrometheusCounter(id, (Counter.Child)this.child(counter, id.getTags())));
    }

    @Override
    public <T> T counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        this.register(new FunctionTrackingCounter<T>(new MeterId(name, this.withCommonTags(tags)), obj, f));
        return obj;
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        Iterable<Tag> allTags = this.withCommonTags(tags);
        MeterId id = new MeterId(name, allTags);
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, name, n -> (CustomPrometheusSummary)new CustomPrometheusSummary(name, StreamSupport.stream(allTags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList())).register(this.registry));
        return MapAccess.computeIfAbsent(this.meterMap, id, t -> new PrometheusDistributionSummary(id, summary.child(allTags, quantiles, histogram)));
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        Iterable<Tag> allTags = this.withCommonTags(tags);
        MeterId id = new MeterId(name, allTags);
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, name, n -> (CustomPrometheusSummary)new CustomPrometheusSummary(name, StreamSupport.stream(allTags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList())).register(this.registry));
        return MapAccess.computeIfAbsent(this.meterMap, id, t -> new PrometheusTimer(id, summary.child(allTags, quantiles, histogram), this.getClock()));
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        Iterable<Tag> allTags = this.withCommonTags(tags);
        MeterId id = new MeterId(name, allTags);
        CustomPrometheusLongTaskTimer longTaskTimer = this.collectorByName(CustomPrometheusLongTaskTimer.class, name, n -> (CustomPrometheusLongTaskTimer)new CustomPrometheusLongTaskTimer(name, StreamSupport.stream(allTags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList()), this.getClock()).register(this.registry));
        return MapAccess.computeIfAbsent(this.meterMap, id, t -> new PrometheusLongTaskTimer(id, longTaskTimer.child(allTags)));
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, final ToDoubleFunction<T> f) {
        final WeakReference ref = new WeakReference(obj);
        Iterable<Tag> allTags = this.withCommonTags(tags);
        MeterId id = new MeterId(name, allTags);
        Gauge gauge = this.collectorByName(Gauge.class, name, i -> (Gauge)this.buildCollector(id, (SimpleCollector.Builder)Gauge.build()));
        MapAccess.computeIfAbsent(this.meterMap, id, g -> {
            String[] labelValues = id.getTags().stream().map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]);
            Gauge.Child child = new Gauge.Child(){

                public double get() {
                    Object obj = ref.get();
                    return obj == null ? Double.NaN : f.applyAsDouble(obj);
                }
            };
            gauge.setChild((Object)child, labelValues);
            return new PrometheusGauge(id, child);
        });
        return obj;
    }

    @Override
    public MeterRegistry register(Meter meter) {
        this.meterMap.computeIfAbsent(new MeterId(meter.getName(), meter.getTags()), id -> {
            CustomPrometheusCollector c = (CustomPrometheusCollector)this.collectorMap.computeIfAbsent(meter.getName(), name -> {
                Collector.Type type = Collector.Type.UNTYPED;
                switch (meter.getType()) {
                    case Counter: {
                        type = Collector.Type.COUNTER;
                        break;
                    }
                    case Gauge: {
                        type = Collector.Type.GAUGE;
                        break;
                    }
                    case DistributionSummary: 
                    case Timer: {
                        type = Collector.Type.SUMMARY;
                    }
                }
                CustomPrometheusCollector collector = new CustomPrometheusCollector((String)name, type);
                this.registry.register((Collector)collector);
                return collector;
            });
            c.child(meter::measure);
            return meter;
        });
        return this;
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private <B extends SimpleCollector.Builder<B, C>, C extends SimpleCollector<D>, D> C buildCollector(MeterId id, SimpleCollector.Builder<B, C> builder) {
        return (C)builder.name(tagFormatter.formatName(id.getName())).help(" ").labelNames(id.getTags().stream().map(t -> tagFormatter.formatTagKey(t.getKey())).collect(Collectors.toList()).toArray(new String[0])).register(this.registry);
    }

    private <C extends SimpleCollector<D>, D> D child(C collector, List<Tag> tags) {
        return (D)collector.labels(tags.stream().map(t -> tagFormatter.formatTagValue(t.getValue())).collect(Collectors.toList()).toArray(new String[0]));
    }

    private <C extends Collector> C collectorByName(Class<C> collectorType, String name, Function<String, C> ifAbsent) {
        Collector collector = (Collector)MapAccess.computeIfAbsent(this.collectorMap, name, ifAbsent);
        if (!collectorType.isInstance(collector)) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (C)collector;
    }
}

