/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus.internal;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.prometheus.internal.CustomCollectorChild;
import io.prometheus.client.Collector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomPrometheusCollector
extends Collector {
    private final String name;
    private final Collector.Type type;
    private final Collection<Child> children = new ConcurrentLinkedQueue<Child>();

    public CustomPrometheusCollector(String name, Collector.Type type) {
        this.type = type;
        this.name = name;
    }

    public Child child(Supplier<List<Measurement>> measurementSupplier) {
        Child child = new Child(measurementSupplier);
        this.children.add(child);
        return child;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.name, this.type, " ", this.children.stream().flatMap(Child::collect).collect(Collectors.toList())));
    }

    class Child
    implements CustomCollectorChild {
        private final Supplier<List<Measurement>> measurementSupplier;

        Child(Supplier<List<Measurement>> measurementSupplier) {
            this.measurementSupplier = measurementSupplier;
        }

        @Override
        public Stream<Collector.MetricFamilySamples.Sample> collect() {
            return this.measurementSupplier.get().stream().map(m -> {
                List keys = m.getTags().stream().map(Tag::getKey).collect(Collectors.toList());
                List values = m.getTags().stream().map(Tag::getValue).collect(Collectors.toList());
                return new Collector.MetricFamilySamples.Sample(CustomPrometheusCollector.this.name, keys, values, m.getValue());
            });
        }
    }
}

