/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Meters;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.simple.SimpleUtils;
import io.micrometer.core.instrument.util.MeterId;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class SimpleDistributionSummary
extends AbstractSimpleMeter
implements DistributionSummary {
    private static final Tag STAT_COUNT_TAG = Tag.of("statistic", "count");
    private static final Tag STAT_AMOUNT_TAG = Tag.of("statistic", "amount");
    private static final Tag TYPE_TAG = SimpleUtils.typeTag(Meter.Type.DistributionSummary);
    private final MeterId countId;
    private final MeterId amountId;
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();

    public SimpleDistributionSummary(MeterId id) {
        super(id);
        this.countId = id.withTags(TYPE_TAG, STAT_COUNT_TAG);
        this.amountId = id.withTags(TYPE_TAG, STAT_AMOUNT_TAG);
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.amount.doubleValue();
    }

    @Override
    public List<Measurement> measure() {
        return Arrays.asList(this.countId.measurement(this.count()), this.amountId.measurement(this.totalAmount()));
    }

    public boolean equals(Object o) {
        return Meters.equals(this, o);
    }

    public int hashCode() {
        return Meters.hashCode(this);
    }
}

