/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Meters;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.simple.SimpleUtils;
import io.micrometer.core.instrument.util.MeterId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleLongTaskTimer
extends AbstractSimpleMeter
implements LongTaskTimer {
    private static final Tag TYPE_TAG = SimpleUtils.typeTag(Meter.Type.LongTaskTimer);
    private static final Tag STAT_ACTIVE_TASKS_TAG = Tag.of("statistic", "activeTasks");
    private static final Tag STAT_DURATION_TAG = Tag.of("statistic", "duration");
    private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
    private final AtomicLong nextTask = new AtomicLong(0L);
    private final Clock clock;
    private final MeterId activeTasksId;
    private final MeterId durationId;

    public SimpleLongTaskTimer(MeterId id, Clock clock) {
        super(id);
        this.clock = clock;
        this.activeTasksId = id.withTags(TYPE_TAG, STAT_ACTIVE_TASKS_TAG);
        this.durationId = id.withTags(TYPE_TAG, STAT_DURATION_TAG);
    }

    @Override
    public long start() {
        long task = this.nextTask.getAndIncrement();
        this.tasks.put(task, this.clock.monotonicTime());
        return task;
    }

    @Override
    public long stop(long task) {
        Long startTime = (Long)this.tasks.get(task);
        if (startTime != null) {
            this.tasks.remove(task);
            return this.clock.monotonicTime() - startTime;
        }
        return -1L;
    }

    @Override
    public long duration(long task) {
        Long startTime = (Long)this.tasks.get(task);
        return startTime != null ? this.clock.monotonicTime() - startTime : -1L;
    }

    @Override
    public long duration() {
        long now = this.clock.monotonicTime();
        long sum = 0L;
        Iterator iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            long startTime = (Long)iterator.next();
            sum += now - startTime;
        }
        return sum;
    }

    @Override
    public int activeTasks() {
        return this.tasks.size();
    }

    @Override
    public List<Measurement> measure() {
        return Arrays.asList(this.activeTasksId.measurement(this.activeTasks()), this.durationId.measurement(this.duration()));
    }

    public boolean equals(Object o) {
        return Meters.equals(this, o);
    }

    public int hashCode() {
        return Meters.hashCode(this);
    }
}

