/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Meters;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.spectator.SpectatorUtils;
import java.util.List;

public class SpectatorMeterWrapper
implements Meter {
    private final String name;
    private final Iterable<Tag> tags;
    private final Meter.Type type;
    private final com.netflix.spectator.api.Meter spectatorCounter;

    public SpectatorMeterWrapper(String name, Iterable<Tag> tags, Meter.Type type, com.netflix.spectator.api.Meter spectatorCounter) {
        this.name = name;
        this.tags = tags;
        this.type = type;
        this.spectatorCounter = spectatorCounter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.tags;
    }

    @Override
    public Meter.Type getType() {
        return this.type;
    }

    @Override
    public List<Measurement> measure() {
        return SpectatorUtils.measurements(this.spectatorCounter);
    }

    public boolean equals(Object o) {
        return Meters.equals(this, o);
    }

    public int hashCode() {
        return Meters.hashCode(this);
    }
}

