/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.GcGenerationAge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;

public class JvmGcMetrics
implements MeterBinder {
    private String youngGenPoolName;
    private String oldGenPoolName;
    private Iterable<Tag> tags;

    public JvmGcMetrics() {
        this(Collections.emptyList());
    }

    public JvmGcMetrics(Iterable<Tag> tags) {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (this.isYoungGenPool(mbean.getName())) {
                this.youngGenPoolName = mbean.getName();
            }
            if (!this.isOldGenPool(mbean.getName())) continue;
            this.oldGenPoolName = mbean.getName();
        }
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        AtomicLong maxDataSize = new AtomicLong(0L);
        registry.gauge(registry.createId("jvm.gc.max.data.size", this.tags, "Max size of old generation memory pool", "bytes"), maxDataSize, AtomicLong::get);
        AtomicLong liveDataSize = new AtomicLong(0L);
        registry.gauge(registry.createId("jvm.gc.live.data.size", this.tags, "Size of old generation memory pool after a full GC", "bytes"), liveDataSize, AtomicLong::get);
        Counter promotionRate = registry.counter(registry.createId("jvm.gc.promotion.rate", this.tags, "Count of positive increases in the size of the old generation memory pool before GC to after GC"));
        Counter allocationRate = registry.counter(registry.createId("jvm.gc.allocation.rate", this.tags, "Incremented for an increase in the size of the young generation memory pool after one GC to before the next"));
        AtomicLong youngGenSizeAfter = new AtomicLong(0L);
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)mbean)).addNotificationListener((notification, ref) -> {
                String type = notification.getType();
                if (type.equals("com.sun.management.gc.notification")) {
                    long delta;
                    CompositeData cd = (CompositeData)notification.getUserData();
                    GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                    if (this.isConcurrentPhase(notificationInfo)) {
                        registry.timer(registry.createId("jvm.gc.concurrent.phase.time", Tags.zip("action", notificationInfo.getGcAction(), "cause", notificationInfo.getGcCause()), "Time spent in concurrent phase"), null, null).record(notificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                    } else {
                        registry.timer(registry.createId("jvm.gc.pause", Tags.zip("action", notificationInfo.getGcAction(), "cause", notificationInfo.getGcCause()), "Time spent in GC pause"), null, null).record(notificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                    }
                    GcInfo gcInfo = notificationInfo.getGcInfo();
                    Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                    Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                    if (this.oldGenPoolName != null) {
                        long oldBefore = before.get(this.oldGenPoolName).getUsed();
                        long oldAfter = after.get(this.oldGenPoolName).getUsed();
                        delta = oldAfter - oldBefore;
                        if (delta > 0L) {
                            promotionRate.increment(delta);
                        }
                        if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                            liveDataSize.set(oldAfter);
                            long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                            maxDataSize.set(oldMaxAfter);
                        }
                    }
                    if (this.youngGenPoolName != null) {
                        long youngBefore = before.get(this.youngGenPoolName).getUsed();
                        long youngAfter = after.get(this.youngGenPoolName).getUsed();
                        delta = youngBefore - youngGenSizeAfter.get();
                        youngGenSizeAfter.set(youngAfter);
                        if (delta > 0L) {
                            allocationRate.increment(delta);
                        }
                    }
                }
            }, null, null);
        }
    }

    private boolean isConcurrentPhase(GarbageCollectionNotificationInfo info) {
        return "No GC".equals(info.getGcCause());
    }

    private boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    private boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }
}

