/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Histogram;
import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.MeterEquivalence;
import java.util.concurrent.atomic.DoubleAdder;

public class DropwizardDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    private final Histogram impl;
    private final DoubleAdder totalAmount = new DoubleAdder();
    private final Quantiles quantiles;
    private final io.micrometer.core.instrument.stats.hist.Histogram<?> histogram;

    DropwizardDistributionSummary(Meter.Id id, Histogram impl, Quantiles quantiles, io.micrometer.core.instrument.stats.hist.Histogram<?> histogram) {
        super(id);
        this.impl = impl;
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.impl.update((long)amount);
            this.totalAmount.add(amount);
            if (this.quantiles != null) {
                this.quantiles.observe(amount);
            }
            if (this.histogram != null) {
                this.histogram.observe(amount);
            }
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalAmount() {
        return this.totalAmount.doubleValue();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

