/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final Quantiles quantiles;
    private final Histogram<?> histogram;

    DropwizardTimer(Meter.Id id, Timer impl, Clock clock, Quantiles quantiles, Histogram<?> histogram) {
        super(id, clock);
        this.impl = impl;
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.impl.update(amount, unit);
            long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.totalTime.addAndGet(nanoAmount);
            if (this.quantiles != null) {
                this.quantiles.observe(nanoAmount);
            }
            if (this.histogram != null) {
                this.histogram.observe(nanoAmount);
            }
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.convert(this.totalTime.get(), TimeUnit.NANOSECONDS, unit);
    }
}

