/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.reactor;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.reactor.ReactorMetricsSubscriber;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;

public class ReactorMetrics {
    private static final Predicate<Scannable> POINTCUT_FILTER = s -> !(s instanceof Fuseable.ScalarCallable);

    private ReactorMetrics() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> timed(Iterable<Tag> tags) {
        return Operators.lift(POINTCUT_FILTER, (scannable, sub) -> {
            if (scannable instanceof Fuseable && sub instanceof Fuseable.QueueSubscription) {
                return sub;
            }
            return new ReactorMetricsSubscriber(scannable.name(), Tags.concat(tags, scannable.tags().map(t -> Tag.of((String)t.getT1(), (String)t.getT2())).collect(Collectors.toList())));
        });
    }
}

