/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.MeterEquivalence;

public class SpectatorDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    private final com.netflix.spectator.api.DistributionSummary distributionSummary;
    private final Quantiles quantiles;
    private final Histogram<?> histogram;

    public SpectatorDistributionSummary(Meter.Id id, com.netflix.spectator.api.DistributionSummary distributionSummary, Quantiles quantiles, Histogram<?> histogram) {
        super(id);
        this.distributionSummary = distributionSummary;
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    @Override
    public void record(double amount) {
        this.distributionSummary.record((long)amount);
        if (amount > 0.0) {
            if (this.quantiles != null) {
                this.quantiles.observe(amount);
            }
            if (this.histogram != null) {
                this.histogram.observe(amount);
            }
        }
    }

    @Override
    public long count() {
        return this.distributionSummary.count();
    }

    @Override
    public double totalAmount() {
        return this.distributionSummary.totalAmount();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

