/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class SpectatorLongTaskTimer
extends AbstractMeter
implements LongTaskTimer {
    private final com.netflix.spectator.api.LongTaskTimer timer;

    SpectatorLongTaskTimer(Meter.Id id, com.netflix.spectator.api.LongTaskTimer timer) {
        super(id);
        this.timer = timer;
    }

    @Override
    public long start() {
        return this.timer.start();
    }

    @Override
    public long stop(long task) {
        return this.timer.stop(task);
    }

    @Override
    public double duration(long task, TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.timer.duration(task), unit);
    }

    @Override
    public double duration(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.timer.duration(), unit);
    }

    @Override
    public int activeTasks() {
        return this.timer.activeTasks();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

