/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class SpectatorTimer
extends AbstractTimer {
    private final Timer timer;
    private final Quantiles quantiles;
    private final Histogram<?> histogram;

    public SpectatorTimer(Meter.Id id, Timer timer, Clock clock, Quantiles quantiles, Histogram<?> histogram) {
        super(id, clock);
        this.timer = timer;
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanoAmount = unit.toNanos(amount);
        this.timer.record(nanoAmount, TimeUnit.NANOSECONDS);
        if (this.quantiles != null) {
            this.quantiles.observe(nanoAmount);
        }
        if (this.histogram != null) {
            this.histogram.observe(nanoAmount);
        }
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.timer.totalTime(), unit);
    }
}

