/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.DefaultHistogram;
import io.micrometer.core.instrument.stats.hist.PercentileHistogram;
import io.micrometer.core.instrument.stats.hist.PercentileTimeHistogram;
import io.micrometer.core.instrument.stats.hist.TimeHistogram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface Histogram<T> {
    public Collection<Bucket<T>> getBuckets();

    public Histogram<T> filterBuckets(BucketFilter<T> var1);

    public Bucket<T> getBucket(T var1);

    public void observe(double var1);

    public boolean isCumulative();

    public static <U> DefaultHistogram.Builder<U> function(BucketFunction<U> f) {
        return new DefaultHistogram.Builder<U>(f);
    }

    public static DefaultHistogram.Builder<Double> linear(double start, double width, int count) {
        return new DefaultHistogram.Builder<Double>(Histogram.linearFunction(start, width, count));
    }

    public static TimeHistogram.Builder linearTime(TimeUnit unit, double start, double width, int count) {
        return new TimeHistogram.Builder(Histogram.linearFunction(start, width, count), unit);
    }

    public static DefaultHistogram.Builder<Double> exponential(double start, double exp, int count) {
        return new DefaultHistogram.Builder<Double>(Histogram.exponentialFunction(start, exp, count));
    }

    public static TimeHistogram.Builder exponentialTime(TimeUnit unit, double start, double exp, int count) {
        return new TimeHistogram.Builder(Histogram.exponentialFunction(start, exp, count), unit);
    }

    public static PercentileHistogram.Builder percentiles() {
        return new PercentileHistogram.Builder();
    }

    public static PercentileTimeHistogram.Builder percentilesTime() {
        return new PercentileTimeHistogram.Builder(TimeUnit.NANOSECONDS);
    }

    public static BucketFunction<Double> linearFunction(final double start, final double width, final int count) {
        return new BucketFunction<Double>(){

            @Override
            public Double bucket(double d) {
                if (d > start + width * (double)(count - 1)) {
                    return Double.POSITIVE_INFINITY;
                }
                return start + Math.ceil((d - start) / width) * width;
            }

            @Override
            public Collection<Bucket<Double>> buckets() {
                ArrayList<Bucket<Double>> domain = new ArrayList<Bucket<Double>>();
                for (int n = 0; n < count; ++n) {
                    domain.add(new Bucket<Double>(start + (double)n * width, n));
                }
                domain.add(new Bucket<Double>(Double.POSITIVE_INFINITY, domain.size()));
                return domain;
            }
        };
    }

    public static BucketFunction<Double> exponentialFunction(final double start, final double exp, final int count) {
        return new BucketFunction<Double>(){

            @Override
            public Double bucket(double d) {
                if (d > Math.pow(exp, count - 1)) {
                    return Double.POSITIVE_INFINITY;
                }
                if (d - start <= 0.0) {
                    return start;
                }
                double log = Math.log(d) / Math.log(exp);
                return Math.pow(exp, Math.ceil(log));
            }

            @Override
            public Collection<Bucket<Double>> buckets() {
                ArrayList<Bucket<Double>> domain = new ArrayList<Bucket<Double>>();
                for (int n = 0; n < count; ++n) {
                    domain.add(new Bucket<Double>(start * Math.pow(exp, n), n));
                }
                domain.add(new Bucket<Double>(Double.POSITIVE_INFINITY, domain.size()));
                return domain;
            }
        };
    }

    public static abstract class Builder<T> {
        BucketFunction<T> f;
        Summation summation = null;

        Builder(BucketFunction<T> f) {
            this.f = f;
        }

        public Builder<T> summation(Summation summation) {
            this.summation = summation;
            return this;
        }

        public abstract Histogram<T> create(Summation var1);
    }

    public static enum Summation {
        Cumulative,
        Normal;

    }
}

