/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import java.util.ArrayList;
import java.util.Collection;

public class PercentileBucketFunction
implements BucketFunction<Double> {
    public static PercentileBucketFunction INSTANCE;
    private static final int DIGITS = 2;
    private static final double[] BUCKET_VALUES;
    private static final int[] POWER_OF_4_INDEX;

    private PercentileBucketFunction() {
    }

    @Override
    public Double bucket(double d) {
        return BUCKET_VALUES[PercentileBucketFunction.indexOf(d)];
    }

    @Override
    public Collection<? extends Bucket<Double>> buckets() {
        ArrayList<Bucket<Double>> domain = new ArrayList<Bucket<Double>>();
        for (int i = 0; i < BUCKET_VALUES.length; ++i) {
            domain.add(new Bucket<Double>(BUCKET_VALUES[i], i));
        }
        return domain;
    }

    private static int indexOf(double v) {
        long delta;
        long base;
        int offset;
        int pos;
        long prevPowerOf2;
        if (v <= 0.0) {
            return 0;
        }
        if (v <= 4.0) {
            return (int)v;
        }
        int lz = Long.numberOfLeadingZeros((long)v);
        int shift = 64 - lz - 1;
        long prevPowerOf4 = prevPowerOf2 = (long)v >> shift << shift;
        if (shift % 2 != 0) {
            --shift;
            prevPowerOf4 = prevPowerOf2 >> 1;
        }
        return (pos = (offset = (int)((v - (double)(base = prevPowerOf4)) / (double)(delta = base / 3L))) + POWER_OF_4_INDEX[shift / 2]) >= BUCKET_VALUES.length - 1 ? BUCKET_VALUES.length - 1 : pos + 1;
    }

    static {
        int i;
        INSTANCE = new PercentileBucketFunction();
        ArrayList<Integer> powerOf4Index = new ArrayList<Integer>();
        powerOf4Index.add(0);
        ArrayList<Long> buckets = new ArrayList<Long>();
        buckets.add(1L);
        buckets.add(2L);
        buckets.add(3L);
        for (int exp = 2; exp < 64; exp += 2) {
            long current;
            long delta = current / 3L;
            long next = (current << 2) - delta;
            powerOf4Index.add(buckets.size());
            for (current = 1L << exp; current < next; current += delta) {
                buckets.add(current);
            }
        }
        buckets.add(Long.MAX_VALUE);
        BUCKET_VALUES = new double[buckets.size()];
        for (i = 0; i < buckets.size(); ++i) {
            PercentileBucketFunction.BUCKET_VALUES[i] = ((Long)buckets.get(i)).longValue();
        }
        POWER_OF_4_INDEX = new int[powerOf4Index.size()];
        for (i = 0; i < powerOf4Index.size(); ++i) {
            PercentileBucketFunction.POWER_OF_4_INDEX[i] = (Integer)powerOf4Index.get(i);
        }
    }
}

