/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public interface MeterRegistry {
    public Collection<Meter> getMeters();

    public Config config();

    public Search find(String var1);

    public Counter counter(Meter.Id var1);

    default public Counter counter(String name, Iterable<Tag> tags) {
        return this.counter(this.createId(name, tags, null));
    }

    default public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.zip(tags));
    }

    public DistributionSummary summary(Meter.Id var1, Histogram.Builder<?> var2, Quantiles var3);

    default public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return this.summary(this.createId(name, tags, null), null, null);
    }

    default public DistributionSummary summary(String name, String ... tags) {
        return this.summary(name, Tags.zip(tags));
    }

    public Timer timer(Meter.Id var1, Histogram.Builder<?> var2, Quantiles var3);

    default public Timer timer(String name, Iterable<Tag> tags) {
        return this.timer(this.createId(name, tags, null), null, null);
    }

    default public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.zip(tags));
    }

    public More more();

    public Meter register(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    public <T> Gauge gauge(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    default public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        this.gauge(this.createId(name, tags, null), obj, f);
        return obj;
    }

    default public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    default public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    default public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, Collections.emptyList(), obj, f);
    }

    default public <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    default public <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)this.gauge(name, tags, map, Map::size);
    }

    default public Meter.Id createId(String name, Iterable<Tag> tags, String description) {
        return this.createId(name, tags, description, null);
    }

    public Meter.Id createId(String var1, Iterable<Tag> var2, String var3, String var4);

    public static interface More {
        public LongTaskTimer longTaskTimer(Meter.Id var1);

        public <T> FunctionCounter counter(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

        public <T> FunctionTimer timer(Meter.Id var1, T var2, ToLongFunction<T> var3, ToDoubleFunction<T> var4, TimeUnit var5);

        default public <T extends Number> Meter counter(Meter.Id id, T number) {
            return this.counter(id, number, Number::doubleValue);
        }

        public <T> Gauge timeGauge(Meter.Id var1, T var2, TimeUnit var3, ToDoubleFunction<T> var4);
    }

    public static interface Search {
        default public Search tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Search tags(Iterable<Tag> var1);

        public Search value(Statistic var1, double var2);

        public Optional<Timer> timer();

        public Optional<Counter> counter();

        public Optional<Gauge> gauge();

        public Optional<DistributionSummary> summary();

        public Optional<LongTaskTimer> longTaskTimer();

        public Optional<Meter> meter();

        public Collection<Meter> meters();
    }

    public static interface Config {
        public Config commonTags(Iterable<Tag> var1);

        default public Config commonTags(String ... tags) {
            this.commonTags(Tags.zip(tags));
            return this;
        }

        public Iterable<Tag> commonTags();

        public Config namingConvention(NamingConvention var1);

        public NamingConvention namingConvention();

        public Clock clock();
    }
}

