/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter {
    public void record(long var1, TimeUnit var3);

    public <T> T record(Supplier<T> var1);

    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    default public Runnable wrap(Runnable f) {
        return () -> this.record(f);
    }

    public <T> Callable<T> wrap(Callable<T> var1);

    public long count();

    public double totalTime(TimeUnit var1);

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(() -> this.totalTime(TimeUnit.NANOSECONDS), Statistic.TotalTime));
    }

    @Override
    default public Meter.Type getType() {
        return Meter.Type.Timer;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private Quantiles quantiles;
        private Histogram.Builder<?> histogram;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        public Builder quantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public Builder histogram(Histogram.Builder<?> histogram) {
            this.histogram = histogram;
            return this;
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Timer register(MeterRegistry registry) {
            return registry.timer(registry.createId(this.name, this.tags, this.description), this.histogram, this.quantiles);
        }
    }
}

