/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;

public class CaffeineCacheMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final Cache<?, ?> cache;

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new CaffeineCacheMetrics(cache, tags, name).bindTo(registry);
        return cache;
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        CaffeineCacheMetrics.monitor(registry, cache.synchronous(), name, tags);
        return cache;
    }

    public CaffeineCacheMetrics(Cache<?, ?> cache, Iterable<Tag> tags, String name) {
        this.name = name;
        this.tags = tags;
        this.cache = cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge(registry.createId(this.name + ".estimated.size", this.tags, "The approximate number of entries in this cache"), this.cache, Cache::estimatedSize);
        registry.more().counter(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "miss"), "the number of times cache lookup methods have returned an uncached (newly loaded) value, or null"), this.cache, c -> c.stats().missCount());
        registry.more().counter(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "hit"), "The number of times cache lookup methods have returned a cached value."), this.cache, c -> c.stats().hitCount());
        registry.more().counter(registry.createId(this.name + ".evictions", this.tags, "cache evictions"), this.cache, c -> c.stats().evictionCount());
        registry.gauge(registry.createId(this.name + ".eviction.weight", this.tags, "The sum of weights of evicted entries. This total does not include manual invalidations."), this.cache, c -> c.stats().evictionWeight());
        if (this.cache instanceof LoadingCache) {
            registry.more().timeGauge(registry.createId(this.name + ".load.duration", this.tags, "The time the cache has spent loading new values"), this.cache, TimeUnit.NANOSECONDS, c -> c.stats().totalLoadTime());
            registry.more().counter(registry.createId(this.name + ".load", Tags.concat(this.tags, "result", "success"), "The number of times cache lookup methods have successfully loaded a new value"), this.cache, c -> c.stats().loadSuccessCount());
            registry.more().counter(registry.createId(this.name + ".load", Tags.concat(this.tags, "result", "failure"), "The number of times {@link Cache} lookup methods failed to load a new value, either because no value was found or an exception was thrown while loading"), this.cache, c -> c.stats().loadFailureCount());
        }
    }
}

