/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import com.hazelcast.core.IMap;
import com.hazelcast.monitor.LocalMapStats;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;

public class HazelcastCacheMetrics
implements MeterBinder {
    private final IMap<?, ?> cache;
    private final String name;
    private final Iterable<Tag> tags;

    public static <K, V, C extends IMap<K, V>> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return HazelcastCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <K, V, C extends IMap<K, V>> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new HazelcastCacheMetrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    public HazelcastCacheMetrics(IMap<?, ?> cache, String name, Iterable<Tag> tags) {
        this.cache = cache;
        this.name = name;
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        LocalMapStats s = this.cache.getLocalMapStats();
        registry.gauge(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "hit"), "The number of times cache lookup methods have returned a cached value"), this.cache, cache -> cache.getLocalMapStats().getHits());
        registry.gauge(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "miss"), "The number of times cache lookup methods have not returned a value"), this.cache, cache -> {
            LocalMapStats stats = cache.getLocalMapStats();
            return stats.getGetOperationCount() - stats.getHits();
        });
        registry.gauge(registry.createId(this.name + ".entries", Tags.concat(this.tags, "ownership", "backup"), "The number of backup entries held by this member"), this.cache, cache -> cache.getLocalMapStats().getBackupEntryCount());
        registry.gauge(registry.createId(this.name + ".entries", Tags.concat(this.tags, "ownership", "owned"), "The number of owned entries held by this member"), this.cache, cache -> cache.getLocalMapStats().getOwnedEntryCount());
        registry.gauge(registry.createId(this.name + ".entry.memory", Tags.concat(this.tags, "ownership", "backup"), "Memory cost of backup entries held by this member", "bytes"), this.cache, cache -> cache.getLocalMapStats().getBackupEntryMemoryCost());
        registry.gauge(registry.createId(this.name + ".entry.memory", Tags.concat(this.tags, "ownership", "owned"), "Memory cost of owned entries held by this member", "bytes"), this.cache, cache -> cache.getLocalMapStats().getOwnedEntryMemoryCost());
        this.timings(registry);
        this.nearCacheMetrics(registry);
    }

    private void nearCacheMetrics(MeterRegistry registry) {
        if (this.cache.getLocalMapStats().getNearCacheStats() != null) {
            registry.gauge(registry.createId(this.name + ".near.requests", Tags.concat(this.tags, "result", "hit"), "The number of hits (reads) of near cache entries owned by this member"), this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getHits());
            registry.gauge(registry.createId(this.name + ".near.requests", Tags.concat(this.tags, "result", "miss"), "The number of hits (reads) of near cache entries owned by this member"), this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getMisses());
            registry.gauge(registry.createId(this.name + ".near.evictions", this.tags, "The number of evictions of near cache entries owned by this member"), this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getEvictions());
            registry.gauge(registry.createId(this.name + ".near.persistences", this.tags, "The number of Near Cache key persistences (when the pre-load feature is enabled)"), this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getPersistenceCount());
        }
    }

    private void timings(MeterRegistry registry) {
        registry.more().timer(registry.createId(this.name + ".gets", this.tags, "Cache gets"), this.cache, cache -> cache.getLocalMapStats().getGetOperationCount(), cache -> cache.getLocalMapStats().getTotalGetLatency(), TimeUnit.NANOSECONDS);
        registry.more().timer(registry.createId(this.name + ".puts", this.tags, "Cache puts"), this.cache, cache -> cache.getLocalMapStats().getPutOperationCount(), cache -> cache.getLocalMapStats().getTotalPutLatency(), TimeUnit.NANOSECONDS);
        registry.more().timer(registry.createId(this.name + ".removals", this.tags, "Cache removals"), this.cache, cache -> cache.getLocalMapStats().getRemoveOperationCount(), cache -> cache.getLocalMapStats().getTotalRemoveLatency(), TimeUnit.NANOSECONDS);
    }
}

