/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collections;

public class JvmMemoryMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmMemoryMetrics() {
        this(Collections.emptyList());
    }

    public JvmMemoryMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            Iterable<Tag> tagsWithId = Tags.concat(this.tags, "id", bufferPoolBean.getName());
            registry.gauge(registry.createId("jvm.buffer.count", tagsWithId, "An estimate of the number of buffers in the pool"), bufferPoolBean, BufferPoolMXBean::getCount);
            registry.gauge(registry.createId("jvm.buffer.memory.used", tagsWithId, "An estimate of the memory that the Java virtual machine is using for this buffer pool", "bytes"), bufferPoolBean, BufferPoolMXBean::getMemoryUsed);
            registry.gauge(registry.createId("jvm.buffer.total.capacity", tagsWithId, "An estimate of the total capacity of the buffers in this pool", "bytes"), bufferPoolBean, BufferPoolMXBean::getTotalCapacity);
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            Iterable<Tag> tagsWithId = Tags.concat(this.tags, "id", memoryPoolBean.getName(), "area", area);
            registry.gauge(registry.createId("jvm.memory.used", tagsWithId, "The amount of used memory", "bytes"), memoryPoolBean, mem -> mem.getUsage().getUsed());
            registry.gauge(registry.createId("jvm.memory.committed", tagsWithId, "The amount of memory in bytes that is committed for  the Java virtual machine to use", "bytes"), memoryPoolBean, mem -> mem.getUsage().getCommitted());
            registry.gauge(registry.createId("jvm.memory.max", tagsWithId, "The maximum amount of memory in bytes that can be used for memory management", "bytes"), memoryPoolBean, mem -> mem.getUsage().getMax());
        }
    }
}

