/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.slf4j.Marker;

class MetricsTurboFilter
extends TurboFilter {
    private final Counter errorCounter;
    private final Counter warnCounter;
    private final Counter infoCounter;
    private final Counter debugCounter;
    private final Counter traceCounter;

    MetricsTurboFilter(MeterRegistry registry, Iterable<Tag> tags) {
        this.errorCounter = registry.counter(registry.createId("logback.events", Tags.concat(tags, "level", "error"), "Number of error level events that made it to the logs"));
        this.warnCounter = registry.counter(registry.createId("logback.events", Tags.concat(tags, "level", "warn"), "Number of warn level events that made it to the logs"));
        this.infoCounter = registry.counter(registry.createId("logback.events", Tags.concat(tags, "level", "info"), "Number of info level events that made it to the logs"));
        this.debugCounter = registry.counter(registry.createId("logback.events", Tags.concat(tags, "level", "debug"), "Number of debug level events that made it to the logs"));
        this.traceCounter = registry.counter(registry.createId("logback.events", Tags.concat(tags, "level", "trace"), "Number of trace level events that made it to the logs"));
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (level.isGreaterOrEqual(logger.getEffectiveLevel())) {
            switch (level.toInt()) {
                case 40000: {
                    this.errorCounter.increment();
                    break;
                }
                case 30000: {
                    this.warnCounter.increment();
                    break;
                }
                case 20000: {
                    this.infoCounter.increment();
                    break;
                }
                case 10000: {
                    this.debugCounter.increment();
                    break;
                }
                case 5000: {
                    this.traceCounter.increment();
                }
            }
        }
        return FilterReply.NEUTRAL;
    }
}

