/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CompositeFunctionTimer<T>
extends AbstractMeter
implements FunctionTimer,
CompositeMeter {
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnits;
    private final Map<MeterRegistry, FunctionTimer> functionTimers = Collections.synchronizedMap(new LinkedHashMap());

    public CompositeFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.countFunction = countFunction;
        this.totalTimeFunction = totalTimeFunction;
        this.totalTimeFunctionUnits = totalTimeFunctionUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj != null) {
            Map<MeterRegistry, FunctionTimer> map = this.functionTimers;
            synchronized (map) {
                this.functionTimers.put(registry, registry.more().timer(this.getId(), obj, this.countFunction, this.totalTimeFunction, this.totalTimeFunctionUnits));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, FunctionTimer> map = this.functionTimers;
        synchronized (map) {
            this.functionTimers.remove(registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        Map<MeterRegistry, FunctionTimer> map = this.functionTimers;
        synchronized (map) {
            return this.functionTimers.values().stream().findFirst().orElse(NoopFunctionTimer.INSTANCE).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double totalTime(TimeUnit unit) {
        Map<MeterRegistry, FunctionTimer> map = this.functionTimers;
        synchronized (map) {
            return this.functionTimers.values().stream().findFirst().orElse(NoopFunctionTimer.INSTANCE).totalTime(unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeUnit baseTimeUnit() {
        Map<MeterRegistry, FunctionTimer> map = this.functionTimers;
        synchronized (map) {
            return this.functionTimers.values().stream().findFirst().orElse(NoopFunctionTimer.INSTANCE).baseTimeUnit();
        }
    }
}

