/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class MeterId
implements Meter.Id {
    private final String name;
    private final List<Tag> tags;
    private String baseUnit;
    private final String description;
    private Meter.Type type;

    public MeterId(String name, Iterable<Tag> tags, String baseUnit, String description) {
        this.name = name;
        this.tags = Collections.unmodifiableList(StreamSupport.stream(tags.spliterator(), false).sorted(Comparator.comparing(Tag::getKey)).distinct().collect(Collectors.toList()));
        this.baseUnit = baseUnit;
        this.description = description;
    }

    @Override
    public Meter.Id withTag(Tag tag) {
        return new MeterId(this.name, Tags.concat(this.tags, Collections.singletonList(tag)), this.baseUnit, this.description);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getBaseUnit() {
        return this.baseUnit;
    }

    @Override
    public String getConventionName(NamingConvention namingConvention) {
        return namingConvention.name(this.name, this.type, this.baseUnit);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Tag> getConventionTags(NamingConvention namingConvention) {
        return this.tags.stream().map(t -> Tag.of(namingConvention.tagKey(t.getKey()), namingConvention.tagValue(t.getValue()))).collect(Collectors.toList());
    }

    public String toString() {
        return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterId meterId = (MeterId)o;
        return Objects.equals(this.name, meterId.name) && Objects.equals(this.tags, meterId.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }

    @Override
    public void setType(Meter.Type type) {
        this.type = type;
    }

    @Override
    public void setBaseUnit(String baseUnit) {
        this.baseUnit = baseUnit;
    }
}

