/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.MeterEquivalence;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class SimpleDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();
    private final Quantiles quantiles;
    private final Histogram<?> histogram;

    public SimpleDistributionSummary(Meter.Id id, Quantiles quantiles, Histogram<?> histogram) {
        super(id);
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
            if (this.quantiles != null) {
                this.quantiles.observe(amount);
            }
            if (this.histogram != null) {
                this.histogram.observe(amount);
            }
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

