/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleCounter;
import io.micrometer.core.instrument.simple.SimpleDistributionSummary;
import io.micrometer.core.instrument.simple.SimpleGauge;
import io.micrometer.core.instrument.simple.SimpleLongTaskTimer;
import io.micrometer.core.instrument.simple.SimpleTimer;
import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class SimpleMeterRegistry
extends AbstractMeterRegistry {
    public SimpleMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public SimpleMeterRegistry(Clock clock) {
        super(clock);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new SimpleCounter(id);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        this.registerQuantilesGaugeIfNecessary(id, quantiles);
        return new SimpleDistributionSummary(id, quantiles, this.registerHistogramCounterIfNecessary(id, histogram));
    }

    @Override
    protected Timer newTimer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        this.registerQuantilesGaugeIfNecessary(id, quantiles);
        return new SimpleTimer(id, this.config().clock(), quantiles, this.registerHistogramCounterIfNecessary(id, histogram));
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return new SimpleGauge<T>(id, obj, f);
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new SimpleLongTaskTimer(id, this.config().clock());
    }

    private void registerQuantilesGaugeIfNecessary(Meter.Id id, Quantiles quantiles) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                this.gauge(id.getName(), Tags.concat(id.getTags(), "quantile", Double.isNaN(q) ? "NaN" : Double.toString(q)), q, quantiles::get);
            }
        }
    }

    private Histogram<?> registerHistogramCounterIfNecessary(Meter.Id id, Histogram.Builder<?> histogramBuilder) {
        if (histogramBuilder != null) {
            Histogram<?> hist = histogramBuilder.create(Histogram.Summation.Normal);
            for (Bucket<?> bucket : hist.getBuckets()) {
                this.more().counter(this.createId(id.getName(), Tags.concat(id.getTags(), "bucket", bucket.getTagString()), null), bucket, Bucket::getValue);
            }
            return hist;
        }
        return null;
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }
}

