/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.DefaultHistogram;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TimeHistogram
implements Histogram<Double> {
    private final Histogram<Double> delegate;
    private final TimeUnit fUnits;
    private final TimeUnit bucketTimeScale;

    TimeHistogram(Histogram<Double> delegate, TimeUnit bucketTimeScale, TimeUnit fUnits) {
        this.delegate = delegate;
        this.fUnits = fUnits;
        this.bucketTimeScale = bucketTimeScale;
    }

    @Override
    public Collection<Bucket<Double>> getBuckets() {
        return this.delegate.getBuckets().stream().map(unscaledBucket -> TimeHistogram.scaled(unscaledBucket, this.bucketTimeScale, this.fUnits)).collect(Collectors.toList());
    }

    @Override
    public Bucket<Double> getBucket(Double tag) {
        return this.delegate.getBucket(tag);
    }

    @Override
    public void observe(double value) {
        this.delegate.observe(TimeUtils.convert(value, this.bucketTimeScale, this.fUnits));
    }

    @Override
    public boolean isCumulative() {
        return this.delegate.isCumulative();
    }

    private static Bucket<Double> scaled(final Bucket<Double> unscaledBucket, TimeUnit bucketTimeScale, TimeUnit fUnits) {
        return new Bucket<Double>(Double.valueOf(TimeUtils.convert(unscaledBucket.getTag(), fUnits, bucketTimeScale)), unscaledBucket.getIndex().intValue()){

            @Override
            public long getValue() {
                return unscaledBucket.getValue();
            }
        };
    }

    public static class Builder
    extends Histogram.Builder<Double> {
        final TimeUnit fUnits;
        TimeUnit bucketTimeScale = TimeUnit.NANOSECONDS;

        Builder(BucketFunction<Double> f, TimeUnit fUnits) {
            super(f);
            this.fUnits = fUnits;
        }

        public Builder summation(Histogram.Summation summation) {
            return (Builder)super.summation(summation);
        }

        public Builder filterBuckets(BucketFilter<Double> filter) {
            return (Builder)super.filterBuckets(filter);
        }

        public Builder bucketTimeScale(TimeUnit bucketTimeScale) {
            this.bucketTimeScale = bucketTimeScale;
            return this;
        }

        public TimeHistogram create(Histogram.Summation defaultSummationMode) {
            return new TimeHistogram(new DefaultHistogram<Double>(this.f, this.scaledDomainFilters(), this.summation == null ? defaultSummationMode : this.summation), this.bucketTimeScale, this.fUnits);
        }

        Collection<BucketFilter<Double>> scaledDomainFilters() {
            return this.domainFilters.stream().map(filter -> bucket -> filter.shouldPublish(TimeHistogram.scaled(bucket, this.bucketTimeScale, this.fUnits))).collect(Collectors.toList());
        }
    }
}

