/**
 * Copyright 2017 Pivotal Software, Inc.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;

import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class CompositeTimeGauge<T> extends CompositeGauge<T> implements TimeGauge {
    private final TimeUnit fUnit;

    CompositeTimeGauge(Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        super(id, obj, f);
        this.fUnit = fUnit;
    }

    @Override
    public void add(MeterRegistry registry) {
        T obj = ref.get();
        if(obj != null) {
            gauges.put(registry, TimeGauge.builder(getId().getName(), obj, fUnit, f)
                .tags(getId().getTags())
                .description(getId().getDescription())
                .register(registry));
        }
    }

    @Override
    public TimeUnit getBaseTimeUnit() {
        return gauges.values().stream().findFirst().map(tg -> ((TimeGauge) tg).getBaseTimeUnit())
            .orElse(TimeUnit.SECONDS);
    }
}
