/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface LongTaskTimer
extends Meter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordCallable(Callable<T> f) throws Exception {
        long id = this.start();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T record(Supplier<T> f) throws Exception {
        long id = this.start();
        try {
            T t = f.get();
            return t;
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void record(Consumer<Long> f) {
        long id = this.start();
        try {
            f.accept(id);
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void record(Runnable f) {
        long id = this.start();
        try {
            f.run();
        }
        finally {
            this.stop(id);
        }
    }

    public long start();

    public long stop(long var1);

    public double duration(long var1, TimeUnit var3);

    public double duration(TimeUnit var1);

    public int activeTasks();

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.activeTasks(), Statistic.ActiveTasks), new Measurement(() -> this.duration(TimeUnit.NANOSECONDS), Statistic.Duration));
    }

    @Override
    default public Meter.Type getType() {
        return Meter.Type.LongTaskTimer;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public LongTaskTimer register(MeterRegistry registry) {
            return registry.more().longTaskTimer(new Meter.Id(this.name, this.tags, null, this.description));
        }
    }
}

