/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter {
    public void record(long var1, TimeUnit var3);

    default public void record(Duration duration) {
        this.record(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public <T> T record(Supplier<T> var1);

    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    default public Runnable wrap(Runnable f) {
        return () -> this.record(f);
    }

    public <T> Callable<T> wrap(Callable<T> var1);

    public long count();

    public double totalTime(TimeUnit var1);

    default public double mean(TimeUnit unit) {
        return this.count() == 0L ? 0.0 : this.totalTime(unit) / (double)this.count();
    }

    public double max(TimeUnit var1);

    public double percentile(double var1, TimeUnit var3);

    public double histogramCountAtValue(long var1);

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(() -> this.totalTime(TimeUnit.NANOSECONDS), Statistic.TotalTime));
    }

    @Override
    default public Meter.Type getType() {
        return Meter.Type.Timer;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;
        private final HistogramConfig.Builder histogramConfigBuilder;

        private Builder(String name) {
            this.name = name;
            this.histogramConfigBuilder = new HistogramConfig.Builder();
            this.minimumExpectedValue(Duration.ofMillis(1L));
            this.maximumExpectedValue(Duration.ofSeconds(30L));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder publishPercentiles(double ... percentiles) {
            this.histogramConfigBuilder.percentiles(percentiles);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(Boolean enabled) {
            this.histogramConfigBuilder.percentilesHistogram(enabled);
            return this;
        }

        public Builder sla(Duration ... sla) {
            long[] slaNano = new long[sla.length];
            for (int i = 0; i < slaNano.length; ++i) {
                slaNano[i] = sla[i].toNanos();
            }
            this.histogramConfigBuilder.sla(slaNano);
            return this;
        }

        public Builder minimumExpectedValue(Duration min) {
            this.histogramConfigBuilder.minimumExpectedValue(min.toNanos());
            return this;
        }

        public Builder maximumExpectedValue(Duration max) {
            this.histogramConfigBuilder.maximumExpectedValue(max.toNanos());
            return this;
        }

        public Builder histogramExpiry(Duration expiry) {
            this.histogramConfigBuilder.histogramExpiry(expiry);
            return this;
        }

        public Builder histogramBufferLength(Integer bufferLength) {
            this.histogramConfigBuilder.histogramBufferLength(bufferLength);
            return this;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Timer register(MeterRegistry registry) {
            return registry.timer(new Meter.Id(this.name, this.tags, null, this.description), this.histogramConfigBuilder.build());
        }
    }
}

