/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CompositeFunctionTimer<T>
extends AbstractMeter
implements FunctionTimer,
CompositeMeter {
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnits;
    private final Map<MeterRegistry, FunctionTimer> functionTimers = new ConcurrentHashMap<MeterRegistry, FunctionTimer>();

    CompositeFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.countFunction = countFunction;
        this.totalTimeFunction = totalTimeFunction;
        this.totalTimeFunctionUnits = totalTimeFunctionUnits;
    }

    @Override
    public void add(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj != null) {
            FunctionTimer.Builder builder = FunctionTimer.builder(this.getId().getName(), obj, this.countFunction, this.totalTimeFunction, this.totalTimeFunctionUnits).tags(this.getId().getTags()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit());
            this.functionTimers.put(registry, builder.register(registry));
        }
    }

    @Override
    public void remove(MeterRegistry registry) {
        this.functionTimers.remove(registry);
    }

    @Override
    public long count() {
        return this.first().count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return this.first().totalTime(unit);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.first().baseTimeUnit();
    }

    private FunctionTimer first() {
        return this.functionTimers.values().stream().findFirst().orElse(new NoopFunctionTimer(this.getId()));
    }
}

