/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopGauge;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToDoubleFunction;

public class CompositeGauge<T>
extends AbstractMeter
implements Gauge,
CompositeMeter {
    protected final WeakReference<T> ref;
    protected final ToDoubleFunction<T> f;
    protected final Map<MeterRegistry, Gauge> gauges = new ConcurrentHashMap<MeterRegistry, Gauge>();

    CompositeGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.f = f;
    }

    @Override
    public double value() {
        return this.gauges.values().stream().findFirst().orElse(new NoopGauge(this.getId())).value();
    }

    @Override
    public void add(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj != null) {
            this.gauges.put(registry, Gauge.builder(this.getId().getName(), obj, this.f).tags(this.getId().getTags()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit()).register(registry));
        }
    }

    @Override
    public void remove(MeterRegistry registry) {
        this.gauges.remove(registry);
    }
}

