/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.composite.CompositeGauge;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class CompositeTimeGauge<T>
extends CompositeGauge<T>
implements TimeGauge {
    private final TimeUnit fUnit;

    CompositeTimeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        super(id, obj, f);
        this.fUnit = fUnit;
    }

    @Override
    public void add(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj != null) {
            this.gauges.put(registry, TimeGauge.builder(this.getId().getName(), obj, this.fUnit, this.f).tags(this.getId().getTags()).description(this.getId().getDescription()).register(registry));
        }
    }

    @Override
    public TimeUnit getBaseTimeUnit() {
        return this.gauges.values().stream().findFirst().map(tg -> ((TimeGauge)tg).getBaseTimeUnit()).orElse(TimeUnit.SECONDS);
    }
}

