/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.histogram.PercentileHistogramBuckets;
import io.micrometer.core.instrument.internal.Mergeable;
import java.time.Duration;
import java.util.NavigableSet;
import java.util.TreeSet;

@Incubating(since="1.0.0-rc.3")
public class HistogramConfig
implements Mergeable<HistogramConfig> {
    private Boolean percentileHistogram;
    private double[] percentiles;
    private long[] sla;
    private Long minimumExpectedValue;
    private Long maximumExpectedValue;
    private Duration histogramExpiry;
    private Integer histogramBufferLength;
    public static HistogramConfig DEFAULT = HistogramConfig.builder().percentilesHistogram(false).percentiles(new double[0]).sla(new long[0]).minimumExpectedValue(1L).maximumExpectedValue(Long.MAX_VALUE).histogramExpiry(Duration.ofMinutes(2L)).histogramBufferLength(5).build();

    @Override
    public HistogramConfig merge(HistogramConfig parent) {
        return HistogramConfig.builder().percentilesHistogram(this.percentileHistogram == null ? parent.percentileHistogram : this.percentileHistogram).percentiles(this.percentiles == null ? parent.percentiles : this.percentiles).sla(this.sla == null ? parent.sla : this.sla).minimumExpectedValue(this.minimumExpectedValue == null ? parent.minimumExpectedValue : this.minimumExpectedValue).maximumExpectedValue(this.maximumExpectedValue == null ? parent.maximumExpectedValue : this.maximumExpectedValue).histogramExpiry(this.histogramExpiry == null ? parent.histogramExpiry : this.histogramExpiry).histogramBufferLength(this.histogramBufferLength == null ? parent.histogramBufferLength : this.histogramBufferLength).build();
    }

    public boolean isPublishingHistogram() {
        return this.percentileHistogram != false || this.sla.length > 0;
    }

    public NavigableSet<Long> getHistogramBuckets(boolean supportsAggregablePercentiles) {
        TreeSet<Long> buckets = new TreeSet<Long>();
        if (this.percentileHistogram.booleanValue() && supportsAggregablePercentiles) {
            buckets.addAll(PercentileHistogramBuckets.buckets(this));
            buckets.add(this.minimumExpectedValue);
            buckets.add(this.maximumExpectedValue);
            buckets.add(Long.MAX_VALUE);
        }
        for (long slaBoundary : this.sla) {
            buckets.add(slaBoundary);
        }
        return buckets;
    }

    public Boolean isPercentileHistogram() {
        return this.percentileHistogram;
    }

    public double[] getPercentiles() {
        return this.percentiles;
    }

    public Long getMinimumExpectedValue() {
        return this.minimumExpectedValue;
    }

    public Long getMaximumExpectedValue() {
        return this.maximumExpectedValue;
    }

    public Duration getHistogramExpiry() {
        return this.histogramExpiry;
    }

    public Integer getHistogramBufferLength() {
        return this.histogramBufferLength;
    }

    public long[] getSlaBoundaries() {
        return this.sla;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ double[] access$102(HistogramConfig x0, double[] x1) {
        x0.percentiles = x1;
        return x1;
    }

    static /* synthetic */ long[] access$202(HistogramConfig x0, long[] x1) {
        x0.sla = x1;
        return x1;
    }

    public static class Builder {
        private HistogramConfig config = new HistogramConfig();

        public Builder percentilesHistogram(Boolean enabled) {
            this.config.percentileHistogram = enabled;
            return this;
        }

        public Builder percentiles(double ... percentiles) {
            HistogramConfig.access$102(this.config, percentiles);
            return this;
        }

        public Builder sla(long ... sla) {
            HistogramConfig.access$202(this.config, sla);
            return this;
        }

        public Builder minimumExpectedValue(Long min) {
            this.config.minimumExpectedValue = min;
            return this;
        }

        public Builder maximumExpectedValue(Long max) {
            this.config.maximumExpectedValue = max;
            return this;
        }

        public Builder histogramExpiry(Duration expiry) {
            this.config.histogramExpiry = expiry;
            return this;
        }

        public Builder histogramBufferLength(Integer bufferLength) {
            this.config.histogramBufferLength = bufferLength;
            return this;
        }

        public HistogramConfig build() {
            return this.config;
        }
    }
}

