/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.DoubleRecorder;

@Incubating(since="1.0.0-rc.3")
public class TimeWindowHistogram {
    private final Clock clock;
    private final DoubleRecorder[] recorderRingBuffer;
    private final DoubleHistogram intervalHistogram;
    private final DoubleHistogram accumulatedHistogram;
    private final AtomicBoolean accumulatedHistogramStale = new AtomicBoolean(false);
    private int currentBucket;
    private long lastRotateTimestampMillis;
    private final long durationBetweenRotatesMillis;

    public TimeWindowHistogram(Clock clock, HistogramConfig histogramConfig) {
        this.clock = clock;
        int ageBuckets = histogramConfig.getHistogramBufferLength();
        this.recorderRingBuffer = new DoubleRecorder[ageBuckets];
        this.intervalHistogram = new DoubleHistogram(3);
        this.accumulatedHistogram = new DoubleHistogram(3);
        for (int i = 0; i < ageBuckets; ++i) {
            this.recorderRingBuffer[i] = new DoubleRecorder(3);
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = clock.wallTime();
        this.durationBetweenRotatesMillis = histogramConfig.getHistogramExpiry().toMillis() / (long)ageBuckets;
    }

    public double percentile(double percentile) {
        return this.current().getValueAtPercentile(percentile * 100.0);
    }

    public double histogramCountAtValue(double value) {
        return this.current().getCountBetweenValues(0.0, value);
    }

    public void record(double value) {
        this.rotate();
        try {
            for (DoubleRecorder recorder : this.recorderRingBuffer) {
                recorder.recordValue(value);
            }
            this.accumulatedHistogramStale.compareAndSet(false, true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void rotate() {
        long timeSinceLastRotateMillis = this.clock.wallTime() - this.lastRotateTimestampMillis;
        while (timeSinceLastRotateMillis > this.durationBetweenRotatesMillis) {
            this.recorderRingBuffer[this.currentBucket].reset();
            this.accumulatedHistogram.reset();
            if (++this.currentBucket >= this.recorderRingBuffer.length) {
                this.currentBucket = 0;
            }
            timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis;
            this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
            this.accumulatedHistogramStale.compareAndSet(false, true);
        }
    }

    private DoubleHistogram current() {
        this.rotate();
        if (this.accumulatedHistogramStale.compareAndSet(true, false)) {
            this.recorderRingBuffer[this.currentBucket].getIntervalHistogramInto(this.intervalHistogram);
            this.accumulatedHistogram.add(this.intervalHistogram);
        }
        return this.accumulatedHistogram;
    }
}

