/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

import com.google.common.math.IntMath;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.math.RoundingMode;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class MeterPartition
extends AbstractList<List<Meter>> {
    private final List<Meter> list;
    private final int size;

    public MeterPartition(MeterRegistry registry, int size) {
        this.list = new ArrayList<Meter>(registry.getMeters());
        this.size = size;
    }

    @Override
    public List<Meter> get(int index) {
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return IntMath.divide((int)this.list.size(), (int)this.size, (RoundingMode)RoundingMode.CEILING);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static List<List<Meter>> partition(MeterRegistry registry, int size) {
        return new MeterPartition(registry, size);
    }
}

