/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public final class ValueAtPercentile {
    private final double percentile;
    private final double value;

    public static ValueAtPercentile of(double percentile, double value) {
        return new ValueAtPercentile(percentile, value);
    }

    private ValueAtPercentile(double percentile, double value) {
        this.percentile = percentile;
        this.value = value;
    }

    public double percentile() {
        return this.percentile;
    }

    public double value() {
        return this.value;
    }

    public double value(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.value, unit);
    }

    public String toString() {
        return "(" + this.value + " at " + this.percentile * 100.0 + "%)";
    }
}

