/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.metric.consumer.CumulativeCommandEventCounterStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricsPublisherCommand
implements HystrixMetricsPublisherCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerMetricsPublisherCommand.class);
    private final MeterRegistry meterRegistry;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final List<Tag> tags;
    private final HystrixCommandProperties properties;
    private final HystrixCommandKey commandKey;

    public MicrometerMetricsPublisherCommand(MeterRegistry meterRegistry, HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        this.meterRegistry = meterRegistry;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.commandKey = commandKey;
        this.properties = properties;
        this.tags = Tags.zip("group", commandGroupKey.name(), "key", commandKey.name());
    }

    public void initialize() {
        Gauge.builder("hystrix.circuit.breaker.open", this.circuitBreaker, c -> c.isOpen() ? 1.0 : 0.0).tags(this.tags).register(this.meterRegistry);
        String executionName = "hystrix.execution";
        String executionDescription = "Execution results. See https://github.com/Netflix/Hystrix/wiki/Metrics-and-Monitoring#command-execution-event-types-comnetflixhystrixhystrixeventtype for type definitions";
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.EMIT);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.SUCCESS);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.FAILURE);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.TIMEOUT);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.BAD_REQUEST);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.SHORT_CIRCUITED);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
        this.createCounter(executionName, executionDescription, HystrixRollingNumberEvent.SEMAPHORE_REJECTED);
        String fallbackEventName = "hystrix.fallback";
        String fallbackEventDescription = "Fallback execution results. See https://github.com/Netflix/Hystrix/wiki/Metrics-and-Monitoring#command-fallback-event-types-comnetflixhystrixhystrixeventtype for type definitions";
        this.createCounter(fallbackEventName, fallbackEventDescription, HystrixRollingNumberEvent.FALLBACK_EMIT);
        this.createCounter(fallbackEventName, fallbackEventDescription, HystrixRollingNumberEvent.FALLBACK_SUCCESS);
        this.createCounter(fallbackEventName, fallbackEventDescription, HystrixRollingNumberEvent.FALLBACK_FAILURE);
        this.createCounter(fallbackEventName, fallbackEventDescription, HystrixRollingNumberEvent.FALLBACK_REJECTION);
        this.createCounter(fallbackEventName, fallbackEventDescription, HystrixRollingNumberEvent.FALLBACK_MISSING);
        CumulativeCommandEventCounterStream.getInstance((HystrixCommandKey)this.commandKey, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
    }

    private void createCounter(String name, String executionDescription, HystrixRollingNumberEvent event) {
        ToDoubleFunction<HystrixCommandMetrics> getCumulativeCount = m -> {
            try {
                return m.getCumulativeCount(event);
            }
            catch (NoSuchFieldError error) {
                LOG.error("While publishing metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                return 0.0;
            }
        };
        FunctionCounter.builder(name, this.metrics, getCumulativeCount).description(executionDescription).tags(Tags.concat(this.tags, "event", event.name().toLowerCase())).register(this.meterRegistry);
    }
}

