/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public final class CountAtValue {
    private final long value;
    private final double count;

    public static CountAtValue of(long value, double count) {
        return new CountAtValue(value, count);
    }

    private CountAtValue(long value, double count) {
        this.value = value;
        this.count = count;
    }

    public long value() {
        return this.value;
    }

    public double value(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.value, unit);
    }

    public double count() {
        return this.count;
    }

    public String toString() {
        return "(" + this.count + " at " + this.value + ')';
    }
}

