/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.noop.NoopTimer;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class CompositeTimer
extends AbstractCompositeMeter<Timer>
implements Timer {
    private final Clock clock;
    private final HistogramConfig histogramConfig;

    CompositeTimer(Meter.Id id, Clock clock, HistogramConfig histogramConfig) {
        super(id);
        this.clock = clock;
        this.histogramConfig = histogramConfig;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.forEachChild(ds -> ds.record(amount, unit));
    }

    @Override
    public void record(Duration duration) {
        this.forEachChild(ds -> ds.record(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> f) {
        long s = this.clock.monotonicTime();
        try {
            T t = f.get();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return ((Timer)this.firstChild()).count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return ((Timer)this.firstChild()).totalTime(unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return ((Timer)this.firstChild()).max(unit);
    }

    @Override
    public double percentile(double percentile, TimeUnit unit) {
        return ((Timer)this.firstChild()).percentile(percentile, unit);
    }

    @Override
    public double histogramCountAtValue(long valueNanos) {
        return ((Timer)this.firstChild()).histogramCountAtValue(valueNanos);
    }

    @Override
    public HistogramSnapshot takeSnapshot(boolean supportsAggregablePercentiles) {
        return ((Timer)this.firstChild()).takeSnapshot(supportsAggregablePercentiles);
    }

    @Override
    Timer newNoopMeter() {
        return new NoopTimer(this.getId());
    }

    @Override
    Timer registerNewMeter(MeterRegistry registry) {
        long[] slaNanos = this.histogramConfig.getSlaBoundaries();
        Duration[] sla = new Duration[slaNanos.length];
        for (int i = 0; i < slaNanos.length; ++i) {
            sla[i] = Duration.ofNanos(slaNanos[i]);
        }
        return Timer.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).maximumExpectedValue(Duration.ofNanos(this.histogramConfig.getMaximumExpectedValue())).minimumExpectedValue(Duration.ofNanos(this.histogramConfig.getMinimumExpectedValue())).publishPercentiles(this.histogramConfig.getPercentiles()).publishPercentileHistogram(this.histogramConfig.isPercentileHistogram()).maximumExpectedValue(Duration.ofNanos(this.histogramConfig.getMaximumExpectedValue())).minimumExpectedValue(Duration.ofNanos(this.histogramConfig.getMinimumExpectedValue())).histogramBufferLength(this.histogramConfig.getHistogramBufferLength()).histogramExpiry(this.histogramConfig.getHistogramExpiry()).sla(sla).register(registry);
    }
}

