/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import com.google.common.util.concurrent.AtomicDouble;
import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class CumulativeDistributionSummary
extends AbstractDistributionSummary {
    private final AtomicLong count = new AtomicLong();
    private final AtomicDouble total = new AtomicDouble();
    private final AtomicDouble max = new AtomicDouble();

    public CumulativeDistributionSummary(Meter.Id id, Clock clock, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
    }

    @Override
    protected void recordNonNegative(double amount) {
        this.count.getAndAdd(1L);
        this.total.getAndAdd(amount);
        this.updateMax(amount);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalAmount() {
        return this.total.get();
    }

    @Override
    public double max() {
        return this.max.get();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(this::totalAmount, Statistic.Total), new Measurement(this::max, Statistic.Max));
    }

    private void updateMax(double amount) {
        double currentMax;
        do {
            if (!((currentMax = this.max.get()) >= amount)) continue;
            return;
        } while (!this.max.compareAndSet(currentMax, amount));
    }
}

