/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepLong;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class StepTimer
extends AbstractTimer {
    private final StepLong count;
    private final StepLong total;
    private final StepLong max;

    public StepTimer(Meter.Id id, Clock clock, HistogramConfig histogramConfig, long step) {
        super(id, clock, histogramConfig);
        this.count = new StepLong(clock, step);
        this.total = new StepLong(clock, step);
        this.max = new StepLong(clock, step);
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert(amount, unit, TimeUnit.NANOSECONDS);
        this.count.getCurrent().add(1L);
        this.total.getCurrent().add(nanoAmount);
        this.max.getCurrent().add(Math.max(nanoAmount - this.max.getCurrent().longValue(), 0L));
    }

    @Override
    public long count() {
        return (long)this.count.poll();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.total.poll(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.max.poll(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(() -> this.totalTime(TimeUnit.NANOSECONDS), Statistic.TotalTime), new Measurement(() -> this.totalTime(TimeUnit.NANOSECONDS), Statistic.Max));
    }
}

