/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.ClockDriftPauseDetector;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.noop.NoopCounter;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import io.micrometer.core.instrument.noop.NoopFunctionCounter;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import io.micrometer.core.instrument.noop.NoopGauge;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import io.micrometer.core.instrument.noop.NoopMeter;
import io.micrometer.core.instrument.noop.NoopTimeGauge;
import io.micrometer.core.instrument.noop.NoopTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class MeterRegistry {
    protected final Clock clock;
    private final Object meterMapLock = new Object();
    private volatile Map<Meter.Id, Meter> meterMap = Collections.emptyMap();
    private final List<MeterFilter> filters = new CopyOnWriteArrayList<MeterFilter>();
    private final List<Consumer<Meter>> meterAddedListeners = new CopyOnWriteArrayList<Consumer<Meter>>();
    private PauseDetector pauseDetector = new ClockDriftPauseDetector(Duration.ofMillis(100L), Duration.ofMillis(100L));
    private NamingConvention namingConvention = NamingConvention.snakeCase;
    private final Config config = new Config();
    private final More more = new More();

    protected MeterRegistry(Clock clock) {
        this.clock = clock;
    }

    protected abstract <T> Gauge newGauge(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected abstract Counter newCounter(Meter.Id var1);

    protected abstract LongTaskTimer newLongTaskTimer(Meter.Id var1);

    protected abstract Timer newTimer(Meter.Id var1, HistogramConfig var2, PauseDetector var3);

    protected abstract DistributionSummary newDistributionSummary(Meter.Id var1, HistogramConfig var2);

    protected abstract Meter newMeter(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    protected <T> TimeGauge newTimeGauge(final Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        Meter.Id withUnit = id.withBaseUnit(this.getBaseTimeUnitStr());
        final Gauge gauge = this.newGauge(withUnit, obj, obj2 -> TimeUtils.convert(f.applyAsDouble(obj2), fUnit, this.getBaseTimeUnit()));
        return new TimeGauge(){

            @Override
            public Meter.Id getId() {
                return id;
            }

            @Override
            public double value() {
                return gauge.value();
            }

            @Override
            public TimeUnit baseTimeUnit() {
                return MeterRegistry.this.getBaseTimeUnit();
            }
        };
    }

    protected abstract <T> FunctionTimer newFunctionTimer(Meter.Id var1, T var2, ToLongFunction<T> var3, ToDoubleFunction<T> var4, TimeUnit var5);

    protected abstract <T> FunctionCounter newFunctionCounter(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected List<Tag> getConventionTags(Meter.Id id) {
        return id.getConventionTags(this.config().namingConvention());
    }

    protected String getConventionName(Meter.Id id) {
        return id.getConventionName(this.config().namingConvention());
    }

    protected abstract TimeUnit getBaseTimeUnit();

    protected abstract HistogramConfig defaultHistogramConfig();

    private String getBaseTimeUnitStr() {
        if (this.getBaseTimeUnit() == null) {
            return null;
        }
        return this.getBaseTimeUnit().toString().toLowerCase();
    }

    Counter counter(Meter.Id id) {
        return this.registerMeterIfNecessary(Counter.class, id, this::newCounter, NoopCounter::new);
    }

    <T> Gauge gauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return this.registerMeterIfNecessary(Gauge.class, id, id2 -> this.newGauge((Meter.Id)id2, obj, f), NoopGauge::new);
    }

    Timer timer(Meter.Id id, HistogramConfig histogramConfig, PauseDetector pauseDetectorOverride) {
        return this.registerMeterIfNecessary(Timer.class, id, histogramConfig, (id2, filteredConfig) -> {
            Meter.Id withUnit = id2.withBaseUnit(this.getBaseTimeUnitStr());
            return this.newTimer(withUnit, filteredConfig.merge(this.defaultHistogramConfig()), pauseDetectorOverride);
        }, NoopTimer::new);
    }

    DistributionSummary summary(Meter.Id id, HistogramConfig histogramConfig) {
        return this.registerMeterIfNecessary(DistributionSummary.class, id, histogramConfig, (id2, filteredConfig) -> this.newDistributionSummary((Meter.Id)id2, filteredConfig.merge(this.defaultHistogramConfig())), NoopDistributionSummary::new);
    }

    Meter register(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return this.registerMeterIfNecessary(Meter.class, id, id2 -> this.newMeter((Meter.Id)id2, type, measurements), NoopMeter::new);
    }

    public List<Meter> getMeters() {
        return Collections.unmodifiableList(new ArrayList<Meter>(this.meterMap.values()));
    }

    public void forEachMeter(Consumer<? super Meter> consumer) {
        this.meterMap.values().forEach(consumer);
    }

    public Config config() {
        return this.config;
    }

    public Search find(String name) {
        return new Search(name);
    }

    public Counter counter(String name, Iterable<Tag> tags) {
        return Counter.builder(name).tags(tags).register(this);
    }

    public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.zip(tags));
    }

    public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return DistributionSummary.builder(name).tags(tags).register(this);
    }

    public DistributionSummary summary(String name, String ... tags) {
        return this.summary(name, Tags.zip(tags));
    }

    public Timer timer(String name, Iterable<Tag> tags) {
        return Timer.builder(name).tags(tags).register(this);
    }

    public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.zip(tags));
    }

    public More more() {
        return this.more;
    }

    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        Gauge.builder(name, obj, f).tags(tags).register(this);
        return obj;
    }

    public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, Collections.emptyList(), obj, f);
    }

    public <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    public <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)this.gauge(name, tags, map, Map::size);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, Function<Meter.Id, Meter> builder, Function<Meter.Id, M> noopBuilder) {
        return this.registerMeterIfNecessary(meterClass, id, null, (id2, conf) -> (Meter)builder.apply((Meter.Id)id2), noopBuilder);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, HistogramConfig config, BiFunction<Meter.Id, HistogramConfig, Meter> builder, Function<Meter.Id, M> noopBuilder) {
        Meter m;
        Meter.Id mappedId = id;
        for (MeterFilter filter : this.filters) {
            mappedId = filter.map(mappedId);
        }
        if (!this.accept(id)) {
            return (M)((Meter)noopBuilder.apply(id));
        }
        if (config != null) {
            for (MeterFilter filter : this.filters) {
                HistogramConfig filteredConfig = filter.configure(mappedId, config);
                if (filteredConfig == null) continue;
                config = filteredConfig;
            }
        }
        if (!meterClass.isInstance(m = this.getOrCreateMeter(config, builder, mappedId))) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (M)m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Meter getOrCreateMeter(HistogramConfig config, BiFunction<Meter.Id, HistogramConfig, Meter> builder, Meter.Id mappedId) {
        Meter m = this.meterMap.get(mappedId);
        if (m == null) {
            Object object = this.meterMapLock;
            synchronized (object) {
                m = this.meterMap.get(mappedId);
                if (m == null) {
                    m = builder.apply(mappedId, config);
                    this.register(mappedId, m);
                    for (Consumer<Meter> onAdd : this.meterAddedListeners) {
                        onAdd.accept(m);
                    }
                }
            }
        }
        return m;
    }

    private void register(Meter.Id id, Meter meter) {
        HashMap<Meter.Id, Meter> newMeterMap = new HashMap<Meter.Id, Meter>();
        newMeterMap.putAll(this.meterMap);
        newMeterMap.put(id, meter);
        this.meterMap = Collections.unmodifiableMap(newMeterMap);
    }

    private boolean accept(Meter.Id id) {
        for (MeterFilter filter : this.filters) {
            switch (filter.accept(id)) {
                case DENY: {
                    return false;
                }
                case ACCEPT: {
                    return true;
                }
            }
        }
        return true;
    }

    public class More {
        public LongTaskTimer longTaskTimer(String name, String ... tags) {
            return this.longTaskTimer(name, Tags.zip(tags));
        }

        public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
            return LongTaskTimer.builder(name).tags(tags).register(MeterRegistry.this);
        }

        LongTaskTimer longTaskTimer(Meter.Id id) {
            return (LongTaskTimer)MeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, id, id2 -> {
                Meter.Id withUnit = id2.withBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newLongTaskTimer(withUnit);
            }, NoopLongTaskTimer::new);
        }

        public <T> FunctionCounter counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
            return FunctionCounter.builder(name, obj, f).tags(tags).register(MeterRegistry.this);
        }

        public <T extends Number> FunctionCounter counter(String name, Iterable<Tag> tags, T number) {
            return FunctionCounter.builder(name, number, Number::doubleValue).tags(tags).register(MeterRegistry.this);
        }

        <T> FunctionCounter counter(Meter.Id id, T obj, ToDoubleFunction<T> f) {
            return (FunctionCounter)MeterRegistry.this.registerMeterIfNecessary(FunctionCounter.class, id, id2 -> MeterRegistry.this.newFunctionCounter((Meter.Id)id2, obj, f), NoopFunctionCounter::new);
        }

        public <T> FunctionTimer timer(String name, Iterable<Tag> tags, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
            return FunctionTimer.builder(name, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits).tags(tags).register(MeterRegistry.this);
        }

        <T> FunctionTimer timer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
            return (FunctionTimer)MeterRegistry.this.registerMeterIfNecessary(FunctionTimer.class, id, id2 -> {
                Meter.Id withUnit = id2.withBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newFunctionTimer(withUnit, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
            }, NoopFunctionTimer::new);
        }

        public <T> TimeGauge timeGauge(String name, Iterable<Tag> tags, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
            return TimeGauge.builder(name, obj, fUnit, f).tags(tags).register(MeterRegistry.this);
        }

        <T> TimeGauge timeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
            return (TimeGauge)MeterRegistry.this.registerMeterIfNecessary(TimeGauge.class, id, id2 -> MeterRegistry.this.newTimeGauge((Meter.Id)id2, obj, fUnit, f), NoopTimeGauge::new);
        }
    }

    public class Search {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private final Map<Statistic, Double> valueAsserts = new EnumMap<Statistic, Double>(Statistic.class);

        Search(String name) {
            this.name = name;
        }

        public Search tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Search tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Search value(Statistic statistic, double value) {
            this.valueAsserts.put(statistic, value);
            return this;
        }

        public Optional<Timer> timer() {
            return this.findAny(Timer.class);
        }

        public Optional<Counter> counter() {
            return this.findAny(Counter.class);
        }

        public Optional<Gauge> gauge() {
            return this.findAny(Gauge.class);
        }

        public Optional<FunctionCounter> functionCounter() {
            return this.findAny(FunctionCounter.class);
        }

        public Optional<TimeGauge> timeGauge() {
            return this.findAny(TimeGauge.class);
        }

        public Optional<FunctionTimer> functionTimer() {
            return this.findAny(FunctionTimer.class);
        }

        public Optional<DistributionSummary> summary() {
            return this.findAny(DistributionSummary.class);
        }

        public Optional<LongTaskTimer> longTaskTimer() {
            return this.findAny(LongTaskTimer.class);
        }

        private <T> Optional<T> findAny(Class<T> clazz) {
            return this.meters().stream().filter(m -> clazz.isInstance(m)).findAny().map(clazz::cast);
        }

        public Optional<Meter> meter() {
            return this.meters().stream().findAny();
        }

        public Collection<Meter> meters() {
            Stream<Map.Entry> entryStream = MeterRegistry.this.meterMap.entrySet().stream().filter(e -> ((Meter.Id)e.getKey()).getName().equals(this.name));
            if (!this.tags.isEmpty()) {
                entryStream = entryStream.filter(e -> {
                    ArrayList idTags = new ArrayList();
                    ((Meter.Id)e.getKey()).getTags().forEach(idTags::add);
                    return idTags.containsAll(this.tags);
                });
            }
            Stream<Meter> meterStream = entryStream.map(Map.Entry::getValue);
            if (!this.valueAsserts.isEmpty()) {
                meterStream = meterStream.filter(m -> {
                    for (Measurement measurement : m.measure()) {
                        Double value = this.valueAsserts.get((Object)measurement.getStatistic());
                        if (value == null || !(Math.abs(value - measurement.getValue()) > 1.0E-7)) continue;
                        return false;
                    }
                    return true;
                });
            }
            return meterStream.collect(Collectors.toList());
        }
    }

    public class Config {
        public Config commonTags(Iterable<Tag> tags) {
            this.meterFilter(MeterFilter.commonTags(tags));
            return this;
        }

        public Config commonTags(String ... tags) {
            return this.commonTags(Tags.zip(tags));
        }

        @Incubating(since="1.0.0-rc.3")
        public Config meterFilter(MeterFilter filter) {
            MeterRegistry.this.filters.add(filter);
            return this;
        }

        @Incubating(since="1.0.0-rc.6")
        public Config onMeterAdded(Consumer<Meter> meter) {
            MeterRegistry.this.meterAddedListeners.add(meter);
            return this;
        }

        public Config namingConvention(NamingConvention convention) {
            MeterRegistry.this.namingConvention = convention;
            return this;
        }

        public NamingConvention namingConvention() {
            return MeterRegistry.this.namingConvention;
        }

        public Clock clock() {
            return MeterRegistry.this.clock;
        }

        @Incubating(since="1.0.0-rc.6")
        public Config pauseDetector(PauseDetector detector) {
            MeterRegistry.this.pauseDetector = detector;
            return this;
        }

        @Incubating(since="1.0.0-rc.6")
        public PauseDetector pauseDetector() {
            return MeterRegistry.this.pauseDetector;
        }
    }
}

