/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;

public class CaffeineCacheMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final Cache<?, ?> cache;

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new CaffeineCacheMetrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        CaffeineCacheMetrics.monitor(registry, cache.synchronous(), name, tags);
        return cache;
    }

    public CaffeineCacheMetrics(Cache<?, ?> cache, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.cache = cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(this.name + ".estimated.size", this.cache, Cache::estimatedSize).tags(this.tags).description("The approximate number of entries in this cache").register(registry);
        FunctionCounter.builder(this.name + ".requests", this.cache, c -> c.stats().missCount()).tags(this.tags).tags("result", "miss").description("the number of times cache lookup methods have returned an uncached (newly loaded) value, or null").register(registry);
        FunctionCounter.builder(this.name + ".requests", this.cache, c -> c.stats().hitCount()).tags(this.tags).tags("result", "hit").description("The number of times cache lookup methods have returned a cached value.").register(registry);
        FunctionCounter.builder(this.name + ".evictions", this.cache, c -> c.stats().evictionCount()).tags(this.tags).description("cache evictions").register(registry);
        Gauge.builder(this.name + ".eviction.weight", this.cache, c -> c.stats().evictionWeight()).tags(this.tags).description("The sum of weights of evicted entries. This total does not include manual invalidations.").register(registry);
        if (this.cache instanceof LoadingCache) {
            TimeGauge.builder(this.name + ".load.duration", this.cache, TimeUnit.NANOSECONDS, c -> c.stats().totalLoadTime()).tags(this.tags).description("The time the cache has spent loading new values").register(registry);
            FunctionCounter.builder(this.name + ".load", this.cache, c -> c.stats().loadSuccessCount()).tags(this.tags).tags("result", "success").description("The number of times cache lookup methods have successfully loaded a new value").register(registry);
            FunctionCounter.builder(this.name + ".load", this.cache, c -> c.stats().loadFailureCount()).tags(this.tags).tags("result", "failure").description("The number of times {@link Cache} lookup methods failed to load a new value, either because no value was found or an exception was thrown while loading").register(registry);
        }
    }
}

