/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.dropwizard.DropwizardClock;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import io.micrometer.core.instrument.dropwizard.DropwizardFunctionCounter;
import io.micrometer.core.instrument.dropwizard.DropwizardFunctionTimer;
import io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class DropwizardMeterRegistry
extends MeterRegistry {
    private final MetricRegistry registry;
    private final HierarchicalNameMapper nameMapper;
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");
    private final DropwizardClock dropwizardClock;
    private final DropwizardConfig dropwizardConfig;

    public DropwizardMeterRegistry(DropwizardConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        this.dropwizardConfig = config;
        this.dropwizardClock = new DropwizardClock(clock);
        this.registry = new MetricRegistry();
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase);
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        com.codahale.metrics.Meter meter = new com.codahale.metrics.Meter((com.codahale.metrics.Clock)this.dropwizardClock);
        this.registry.register(this.hierarchicalName(id), (Metric)meter);
        return new DropwizardCounter(id, meter);
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        WeakReference ref = new WeakReference(obj);
        com.codahale.metrics.Gauge gauge = () -> {
            Object obj2 = ref.get();
            return obj2 != null ? f.applyAsDouble(ref.get()) : Double.NaN;
        };
        this.registry.register(this.hierarchicalName(id), (Metric)gauge);
        return new DropwizardGauge(id, (com.codahale.metrics.Gauge<Double>)gauge);
    }

    @Override
    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        DropwizardTimer timer = new DropwizardTimer(id, this.registry.timer(this.hierarchicalName(id)), this.clock, histogramConfig, pauseDetector);
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), timer, t -> t.percentile(percentile, this.getBaseTimeUnit()));
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), timer, (T t) -> t.histogramCountAtValue(bucket));
            }
        }
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        DropwizardDistributionSummary summary = new DropwizardDistributionSummary(id, this.clock, this.registry.histogram(this.hierarchicalName(id)), histogramConfig);
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), summary, s -> summary.percentile(percentile));
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), summary, (T s) -> s.histogramCountAtValue(bucket));
            }
        }
        return summary;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock);
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.ActiveTasks)), (Metric)((com.codahale.metrics.Gauge)ltt::activeTasks));
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.Duration)), (Metric)((com.codahale.metrics.Gauge)() -> ltt.duration(TimeUnit.NANOSECONDS)));
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        DropwizardFunctionTimer<T> ft = new DropwizardFunctionTimer<T>(id, this.clock, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
        this.registry.register(this.hierarchicalName(id), (Metric)ft.getDropwizardMeter());
        return ft;
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        DropwizardFunctionCounter<T> fc = new DropwizardFunctionCounter<T>(id, this.clock, obj, f);
        this.registry.register(this.hierarchicalName(id), (Metric)fc.getDropwizardMeter());
        return fc;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            com.codahale.metrics.Gauge cfr_ignored_0 = (com.codahale.metrics.Gauge)this.registry.register(this.hierarchicalName(id.withTag(ms.getStatistic())), (Metric)((com.codahale.metrics.Gauge)ms::getValue));
        });
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private String hierarchicalName(Meter.Id id) {
        return this.nameMapper.toHierarchicalName(id, this.config().namingConvention());
    }

    @Override
    protected HistogramConfig defaultHistogramConfig() {
        return HistogramConfig.builder().histogramExpiry(this.dropwizardConfig.step()).build().merge(HistogramConfig.DEFAULT);
    }
}

