/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepLong;
import io.micrometer.core.instrument.util.TimeDecayingMax;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class StepTimer
extends AbstractTimer {
    private final StepLong count;
    private final StepLong total;
    private final TimeDecayingMax max;

    public StepTimer(Meter.Id id, Clock clock, HistogramConfig histogramConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id, clock, histogramConfig, pauseDetector, baseTimeUnit);
        this.count = new StepLong(clock, histogramConfig.getHistogramExpiry().toMillis());
        this.total = new StepLong(clock, histogramConfig.getHistogramExpiry().toMillis());
        this.max = new TimeDecayingMax(clock, histogramConfig.getHistogramExpiry().toMillis(), histogramConfig.getHistogramBufferLength());
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert(amount, unit, TimeUnit.NANOSECONDS);
        this.count.getCurrent().add(1L);
        this.total.getCurrent().add(nanoAmount);
        this.max.record(amount, unit);
    }

    @Override
    public long count() {
        return (long)this.count.poll();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.total.poll(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }
}

