/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;

public class GuavaCacheMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final Cache<?, ?> cache;

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return GuavaCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new GuavaCacheMetrics(cache, tags, name).bindTo(registry);
        return cache;
    }

    public GuavaCacheMetrics(Cache<?, ?> cache, Iterable<Tag> tags, String name) {
        this.name = name;
        this.tags = tags;
        this.cache = cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(this.name + ".estimated.size", this.cache, Cache::size).tags(this.tags).description("The approximate number of entries in this cache").register(registry);
        FunctionCounter.builder(this.name + ".requests", this.cache, c -> c.stats().missCount()).tags(this.tags).tags("result", "miss").description("The number of times cache lookup methods have returned an uncached (newly loaded) value, or null").register(registry);
        FunctionCounter.builder(this.name + ".requests", this.cache, c -> c.stats().hitCount()).tags(this.tags).tags("result", "hit").description("The number of times cache lookup methods have returned a cached value").register(registry);
        FunctionCounter.builder(this.name + ".evictions", this.cache, c -> c.stats().evictionCount()).tags(this.tags).description("Cache evictions").register(registry);
        if (this.cache instanceof LoadingCache) {
            TimeGauge.builder(this.name + ".load.duration", this.cache, TimeUnit.NANOSECONDS, c -> c.stats().totalLoadTime()).tags(this.tags).description("The time the cache has spent loading new values").register(registry);
            FunctionCounter.builder(this.name + ".load", this.cache, c -> c.stats().loadSuccessCount()).tags(this.tags).tags("result", "success").description("The number of times cache lookup methods have successfully loaded a new value").register(registry);
            FunctionCounter.builder(this.name + ".load", this.cache, c -> c.stats().loadExceptionCount()).tags(this.tags).tags("result", "failure").description("The number of times cache lookup methods threw an exception while loading a new value").register(registry);
        }
    }
}

