/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixCommandCompletionStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricsPublisherCommand
implements HystrixMetricsPublisherCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerMetricsPublisherCommand.class);
    private static final List<HystrixEventType> executionEvents = Arrays.asList(HystrixEventType.EMIT, HystrixEventType.SUCCESS, HystrixEventType.FAILURE, HystrixEventType.TIMEOUT, HystrixEventType.BAD_REQUEST, HystrixEventType.SHORT_CIRCUITED, HystrixEventType.THREAD_POOL_REJECTED, HystrixEventType.SEMAPHORE_REJECTED);
    private static final List<HystrixEventType> fallbackEvents = Arrays.asList(HystrixEventType.FALLBACK_EMIT, HystrixEventType.FALLBACK_SUCCESS, HystrixEventType.FALLBACK_FAILURE, HystrixEventType.FALLBACK_REJECTION, HystrixEventType.FALLBACK_MISSING);
    private static final String NAME_HYSTRIX_CIRCUIT_BREAKER_OPEN = "hystrix.circuit.breaker.open";
    private static final String NAME_HYSTRIX_COMMAND_OTHER = "hystrix.command.other";
    private static final String NAME_HYSTRIX_EXECUTION = "hystrix.execution";
    private static final String NAME_HYSTRIX_FALLBACK = "hystrix.fallback";
    private static final String NAME_HYSTRIX_ERRORS = "hystrix.errors";
    private static final String NAME_HYSTRIX_REQUESTS = "hystrix.requests";
    private static final String NAME_HYSTRIX_LATENCY_EXECUTION = "hystrix.latency.execution";
    private static final String NAME_HYSTRIX_LATENCY_TOTAL = "hystrix.latency.total";
    private static final String NAME_HYSTRIX_THREADPOOL_CONCURRENT_EXECUTION_CURRENT = "hystrix.threadpool.concurrent.execution.current";
    private static final String NAME_HYSTRIX_THREADPOOL_CONCURRENT_EXECUTION_ROLLING_MAX = "hystrix.threadpool.concurrent.execution.rolling.max";
    private static final String DESCRIPTION_HYSTRIX_COMMAND_OTHER = "Other execution results. See https://github.com/Netflix/Hystrix/wiki/Metrics-and-Monitoring#other-command-event-types-comnetflixhystrixhystrixeventtype for type definitions";
    private static final String DESCRIPTION_HYSTRIX_EXECUTION = "Execution results. See https://github.com/Netflix/Hystrix/wiki/Metrics-and-Monitoring#command-execution-event-types-comnetflixhystrixhystrixeventtype for type definitions";
    private static final String DESCRIPTION_HYSTRIX_FALLBACK = "Fallback execution results. See https://github.com/Netflix/Hystrix/wiki/Metrics-and-Monitoring#command-fallback-event-types-comnetflixhystrixhystrixeventtype for type definitions";
    private final MeterRegistry meterRegistry;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final List<Tag> tags;
    private final HystrixCommandProperties properties;
    private final HystrixCommandKey commandKey;

    public MicrometerMetricsPublisherCommand(MeterRegistry meterRegistry, HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        this.meterRegistry = meterRegistry;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.commandKey = commandKey;
        this.properties = properties;
        this.tags = Tags.zip("group", commandGroupKey.name(), "key", commandKey.name());
        Counter.builder(NAME_HYSTRIX_ERRORS).tags(this.tags).register(meterRegistry);
        Counter.builder(NAME_HYSTRIX_REQUESTS).tags(this.tags).register(meterRegistry);
        Timer.builder(NAME_HYSTRIX_LATENCY_EXECUTION).tags(this.tags).register(meterRegistry);
        Timer.builder(NAME_HYSTRIX_LATENCY_TOTAL).tags(this.tags).register(meterRegistry);
        executionEvents.forEach(this::getExecutionCounter);
        fallbackEvents.forEach(this::getFallbackCounter);
        Arrays.stream(HystrixEventType.values()).filter(e -> !executionEvents.contains(e) && !fallbackEvents.contains(e)).forEach(this::getOtherExecutionCounter);
    }

    public void initialize() {
        Gauge.builder(NAME_HYSTRIX_CIRCUIT_BREAKER_OPEN, this.circuitBreaker, c -> c.isOpen() ? 1.0 : 0.0).tags(this.tags).register(this.meterRegistry);
        HystrixCommandCompletionStream.getInstance((HystrixCommandKey)this.commandKey).observe().subscribe(hystrixCommandCompletion -> {
            long totalLatency = hystrixCommandCompletion.getTotalLatency();
            if (totalLatency >= 0L) {
                Timer.builder(NAME_HYSTRIX_LATENCY_TOTAL).tags(this.tags).register(this.meterRegistry).record(totalLatency, TimeUnit.MILLISECONDS);
            } else if (totalLatency < -1L) {
                LOG.warn("received negative totalLatency, event not counted. This indicates a clock skew? {}", hystrixCommandCompletion);
            }
            long executionLatency = hystrixCommandCompletion.getExecutionLatency();
            if (executionLatency >= 0L) {
                Timer.builder(NAME_HYSTRIX_LATENCY_EXECUTION).tags(this.tags).register(this.meterRegistry).record(executionLatency, TimeUnit.MILLISECONDS);
            } else if (executionLatency < -1L) {
                LOG.warn("received negative executionLatency, event not counted. This indicates a clock skew? {}", hystrixCommandCompletion);
            }
            for (HystrixEventType hystrixEventType : HystrixEventType.values()) {
                int count = hystrixCommandCompletion.getEventCounts().getCount(hystrixEventType);
                if (count <= 0) continue;
                switch (hystrixEventType) {
                    case FAILURE: 
                    case TIMEOUT: 
                    case THREAD_POOL_REJECTED: 
                    case SEMAPHORE_REJECTED: {
                        Counter.builder(NAME_HYSTRIX_ERRORS).tags(this.tags).register(this.meterRegistry).increment(count);
                    }
                    case SUCCESS: {
                        Counter.builder(NAME_HYSTRIX_REQUESTS).tags(this.tags).register(this.meterRegistry).increment(count);
                    }
                }
                if (executionEvents.contains(hystrixEventType)) {
                    this.getExecutionCounter(hystrixEventType).increment(count);
                    continue;
                }
                if (fallbackEvents.contains(hystrixEventType)) {
                    this.getFallbackCounter(hystrixEventType).increment(count);
                    continue;
                }
                this.getOtherExecutionCounter(hystrixEventType).increment(count);
            }
        });
        String threadPool = this.metrics.getThreadPoolKey().name();
        Gauge.builder(NAME_HYSTRIX_THREADPOOL_CONCURRENT_EXECUTION_CURRENT, this.metrics, HystrixCommandMetrics::getCurrentConcurrentExecutionCount).tags(Tags.concat(this.tags, "threadpool", threadPool)).register(this.meterRegistry);
        Gauge.builder(NAME_HYSTRIX_THREADPOOL_CONCURRENT_EXECUTION_ROLLING_MAX, this.metrics, HystrixCommandMetrics::getRollingMaxConcurrentExecutions).tags(Tags.concat(this.tags, "threadpool", threadPool)).register(this.meterRegistry);
    }

    private Counter getOtherExecutionCounter(HystrixEventType hystrixEventType) {
        return Counter.builder(NAME_HYSTRIX_COMMAND_OTHER).description(DESCRIPTION_HYSTRIX_COMMAND_OTHER).tags(Tags.concat(this.tags, "event", hystrixEventType.name().toLowerCase())).register(this.meterRegistry);
    }

    private Counter getFallbackCounter(HystrixEventType hystrixEventType) {
        return Counter.builder(NAME_HYSTRIX_FALLBACK).description(DESCRIPTION_HYSTRIX_FALLBACK).tags(Tags.concat(this.tags, "event", hystrixEventType.name().toLowerCase())).register(this.meterRegistry);
    }

    private Counter getExecutionCounter(HystrixEventType hystrixEventType) {
        return Counter.builder(NAME_HYSTRIX_EXECUTION).description(DESCRIPTION_HYSTRIX_EXECUTION).tags(Tags.concat(this.tags, "event", hystrixEventType.name().toLowerCase())).register(this.meterRegistry);
    }
}

