/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;

public class JvmThreadMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmThreadMetrics() {
        this(Collections.emptyList());
    }

    public JvmThreadMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        Gauge.builder("jvm.threads.peak", threadBean, ThreadMXBean::getPeakThreadCount).tags(this.tags).description("the peak live thread count since the Java virtual machine started or peak was reset").register(registry);
        Gauge.builder("jvm.threads.daemon", threadBean, ThreadMXBean::getDaemonThreadCount).tags(this.tags).description("The current number of live daemon threads").register(registry);
        Gauge.builder("jvm.threads.live", threadBean, ThreadMXBean::getThreadCount).tags(this.tags).description("The current number of live threads including both daemon and non-daemon threads").register(registry);
    }
}

