/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.tomcat;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Manager;

public class TomcatMetrics
implements MeterBinder {
    private final Manager manager;
    private final MBeanServer mBeanServer;
    private final Iterable<Tag> tags;

    public static void monitor(MeterRegistry meterRegistry, Manager manager, String ... tags) {
        TomcatMetrics.monitor(meterRegistry, manager, Tags.zip(tags));
    }

    public static void monitor(MeterRegistry meterRegistry, Manager manager, Iterable<Tag> tags) {
        new TomcatMetrics(manager, tags).bindTo(meterRegistry);
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (!mBeanServers.isEmpty()) {
            return (MBeanServer)mBeanServers.get(0);
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    public TomcatMetrics(Manager manager, Iterable<Tag> tags) {
        this(manager, tags, TomcatMetrics.getMBeanServer());
    }

    public TomcatMetrics(Manager manager, Iterable<Tag> tags, MBeanServer mBeanServer) {
        this.tags = tags;
        this.manager = manager;
        this.mBeanServer = mBeanServer;
    }

    @Override
    public void bindTo(MeterRegistry reg) {
        this.registerGlobalRequestMetrics(reg);
        this.registerServletMetrics(reg);
        this.registerCacheMetrics(reg);
        this.registerThreadPoolMetrics(reg);
        if (this.manager == null) {
            return;
        }
        Gauge.builder("tomcat.sessions.active.max", this.manager, Manager::getMaxActive).tags(this.tags).register(reg);
        Gauge.builder("tomcat.sessions.active.current", this.manager, Manager::getActiveSessions).tags(this.tags).register(reg);
        FunctionCounter.builder("tomcat.sessions.created", this.manager, Manager::getSessionCounter).tags(this.tags).register(reg);
        FunctionCounter.builder("tomcat.sessions.expired", this.manager, Manager::getExpiredSessions).tags(this.tags).register(reg);
        FunctionCounter.builder("tomcat.sessions.rejected", this.manager, Manager::getRejectedSessions).tags(this.tags).register(reg);
        TimeGauge.builder("tomcat.sessions.alive.max", this.manager, TimeUnit.SECONDS, Manager::getSessionMaxAliveTime).tags(this.tags).register(reg);
    }

    private void registerThreadPoolMetrics(MeterRegistry reg) {
        this.registerMetricsEventually("type", "ThreadPool", (name, allTags) -> {
            Gauge.builder("tomcat.threads.config.max", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxThreads"))).tags((Iterable<Tag>)allTags).register(reg);
            Gauge.builder("tomcat.threads.busy", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "currentThreadsBusy"))).tags((Iterable<Tag>)allTags).register(reg);
            Gauge.builder("tomcat.threads.current", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "currentThreadCount"))).tags((Iterable<Tag>)allTags).register(reg);
        });
    }

    private void registerCacheMetrics(MeterRegistry reg) {
        this.registerMetricsEventually("type", "StringCache", (name, allTags) -> {
            FunctionCounter.builder("tomcat.cache.access", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "accessCount"))).tags((Iterable<Tag>)allTags).register(reg);
            FunctionCounter.builder("tomcat.cache.hit", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "hitCount"))).tags((Iterable<Tag>)allTags).register(reg);
        });
    }

    private void registerServletMetrics(MeterRegistry reg) {
        this.registerMetricsEventually("j2eeType", "Servlet", (name, allTags) -> {
            FunctionCounter.builder("tomcat.servlet.error", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "errorCount"))).tags((Iterable<Tag>)allTags).register(reg);
            FunctionTimer.builder("tomcat.servlet.request", this.mBeanServer, s -> this.safeLong(() -> s.getAttribute((ObjectName)name, "requestCount")), s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "processingTime")), TimeUnit.MILLISECONDS).tags((Iterable<Tag>)allTags).register(reg);
            TimeGauge.builder("tomcat.servlet.request.max", this.mBeanServer, TimeUnit.MILLISECONDS, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxTime"))).tags((Iterable<Tag>)allTags).register(reg);
        });
    }

    private void registerGlobalRequestMetrics(MeterRegistry reg) {
        this.registerMetricsEventually("type", "GlobalRequestProcessor", (name, allTags) -> {
            FunctionCounter.builder("tomcat.global.sent", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "bytesSent"))).tags((Iterable<Tag>)allTags).baseUnit("bytes").register(reg);
            FunctionCounter.builder("tomcat.global.received", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "bytesReceived"))).tags((Iterable<Tag>)allTags).baseUnit("bytes").register(reg);
            FunctionCounter.builder("tomcat.global.error", this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "errorCount"))).tags((Iterable<Tag>)allTags).register(reg);
            FunctionTimer.builder("tomcat.global.request", this.mBeanServer, s -> this.safeLong(() -> s.getAttribute((ObjectName)name, "requestCount")), s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "processingTime")), TimeUnit.MILLISECONDS).tags((Iterable<Tag>)allTags).register(reg);
            TimeGauge.builder("tomcat.global.request.max", this.mBeanServer, TimeUnit.MILLISECONDS, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxTime"))).tags((Iterable<Tag>)allTags).register(reg);
        });
    }

    private void registerMetricsEventually(String key, String value, BiConsumer<ObjectName, Iterable<Tag>> perObject) {
        try {
            Set<ObjectName> objs = this.mBeanServer.queryNames(new ObjectName("Tomcat:" + key + "=" + value + ",*"), null);
            if (!objs.isEmpty()) {
                objs.forEach(o -> perObject.accept((ObjectName)o, Tags.concat(this.tags, this.nameTag((ObjectName)o))));
                return;
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Error registering Tomcat JMX based metrics", e);
        }
        NotificationListener notificationListener = (notification, handback) -> {
            MBeanServerNotification mbs = (MBeanServerNotification)notification;
            ObjectName obj = mbs.getMBeanName();
            perObject.accept(obj, Tags.concat(this.tags, this.nameTag(obj)));
        };
        NotificationFilter filter = notification -> {
            if (!"JMX.mbean.registered".equals(notification.getType())) {
                return false;
            }
            ObjectName obj = ((MBeanServerNotification)notification).getMBeanName();
            return obj.getDomain().equals("Tomcat") && obj.getKeyProperty(key).equals(value);
        };
        try {
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener, filter, null);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException("Error registering MBean listener", e);
        }
    }

    private double safeDouble(Callable<Object> callable) {
        try {
            return Double.parseDouble(callable.call().toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private long safeLong(Callable<Object> callable) {
        try {
            return Long.parseLong(callable.call().toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private Iterable<Tag> nameTag(ObjectName name) {
        if (name.getKeyProperty("name") != null) {
            return Tags.zip("name", name.getKeyProperty("name").replaceAll("\"", ""));
        }
        return Collections.emptyList();
    }
}

