/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.config;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.time.Duration;

public abstract class PropertyMeterFilter
implements MeterFilter {
    public abstract <V> V get(String var1, Class<V> var2);

    protected <V> V getMostSpecific(String k, String suffix, Class<V> vClass) {
        V v = this.get(k.isEmpty() ? suffix : k + "." + suffix, vClass);
        if (v != null) {
            return v;
        }
        if (k.isEmpty()) {
            return null;
        }
        int lastSep = k.lastIndexOf(46);
        if (lastSep == -1) {
            return this.getMostSpecific("", suffix, vClass);
        }
        return this.getMostSpecific(k.substring(0, lastSep), suffix, vClass);
    }

    @Override
    public MeterFilterReply accept(Meter.Id id) {
        Boolean enabled = this.getMostSpecific(id.getName(), "enabled", Boolean.class);
        if (enabled == null) {
            return MeterFilterReply.NEUTRAL;
        }
        return enabled != false ? MeterFilterReply.ACCEPT : MeterFilterReply.DENY;
    }

    @Override
    public HistogramConfig configure(Meter.Id id, HistogramConfig histogramConfig) {
        Duration histogramExpiry;
        Integer histogramBufferLength;
        double[] percentiles;
        if (!id.getType().equals((Object)Meter.Type.Timer) && !id.getType().equals((Object)Meter.Type.DistributionSummary)) {
            return histogramConfig;
        }
        HistogramConfig.Builder builder = HistogramConfig.builder();
        Boolean percentileHistogram = this.getMostSpecific(id.getName(), "percentileHistogram", Boolean.class);
        if (percentileHistogram != null) {
            builder.percentilesHistogram(percentileHistogram);
        }
        if ((percentiles = this.getMostSpecific(id.getName(), "percentiles", double[].class)) != null) {
            builder.percentiles(percentiles);
        }
        if ((histogramBufferLength = this.getMostSpecific(id.getName(), "histogramBufferLength", Integer.class)) != null) {
            builder.histogramBufferLength(histogramBufferLength);
        }
        if ((histogramExpiry = this.getMostSpecific(id.getName(), "histogramExpiry", Duration.class)) != null) {
            builder.histogramExpiry(histogramExpiry);
        }
        if (id.getType().equals((Object)Meter.Type.Timer)) {
            Duration[] sla;
            Duration min;
            Duration max = this.getMostSpecific(id.getName(), "maximumExpectedValue", Duration.class);
            if (max != null) {
                builder.maximumExpectedValue(max.toNanos());
            }
            if ((min = this.getMostSpecific(id.getName(), "minimumExpectedValue", Duration.class)) != null) {
                builder.minimumExpectedValue(min.toNanos());
            }
            if ((sla = this.getMostSpecific(id.getName(), "sla", Duration[].class)) != null) {
                long[] slaNanos = new long[sla.length];
                for (int i = 0; i < sla.length; ++i) {
                    slaNanos[i] = sla[i].toNanos();
                }
                builder.sla(slaNanos);
            }
        } else if (id.getType().equals((Object)Meter.Type.DistributionSummary)) {
            long[] sla;
            Long min;
            Long max = this.getMostSpecific(id.getName(), "maximumExpectedValue", Long.class);
            if (max != null) {
                builder.maximumExpectedValue(max);
            }
            if ((min = this.getMostSpecific(id.getName(), "minimumExpectedValue", Long.class)) != null) {
                builder.minimumExpectedValue(min);
            }
            if ((sla = this.getMostSpecific(id.getName(), "sla", long[].class)) != null) {
                builder.sla(sla);
            }
        }
        return builder.build().merge(histogramConfig);
    }
}

