/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.util.MathUtils;
import java.util.AbstractList;
import java.util.List;

public class MeterPartition
extends AbstractList<List<Meter>> {
    private final List<Meter> list;
    private final int partitionSize;
    private final int partitionCount;

    public MeterPartition(MeterRegistry registry, int partitionSize) {
        this.list = registry.getMeters();
        this.partitionSize = partitionSize;
        this.partitionCount = MathUtils.divideWithCeilingRoundingMode(this.list.size(), partitionSize);
    }

    @Override
    public List<Meter> get(int index) {
        int start = index * this.partitionSize;
        int end = Math.min(start + this.partitionSize, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return this.partitionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static List<List<Meter>> partition(MeterRegistry registry, int partitionSize) {
        return new MeterPartition(registry, partitionSize);
    }
}

